<form class="form-horizontal" id="supplement_edit_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group row @error('supplement_name') has-error @enderror">
                <label for="supplement_name" class="control-label col-sm-4"> {{ __('Supplement Name') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="supplement_name" id="supplement_name" value="{{ $supplementInfo->supplement_name }}" placeholder="Supplement" required maxlength="30">
                    @if($errors->has('supplement_name'))
                        <p class="text-danger">{{ $errors->first('supplement_name') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('supplement_name_ar') has-error @enderror">
                <label for="supplement_name_ar" class="control-label col-sm-4"> {{ __('Supplement Name (AR)') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="supplement_name_ar" id="supplement_name_ar" value="{{ $supplementInfo->supplement_name_ar }}" placeholder="Supplement" required maxlength="30">
                    @if($errors->has('supplement_name_ar'))
                        <p class="text-danger">{{ $errors->first('supplement_name_ar') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('supplement_code') has-error @enderror">
                <label for="supplement_code" class="control-label col-sm-4"> {{ __('Supplement Code') }}</label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="supplement_code" id="supplement_code" value="{{ $supplementInfo->supplement_code }}" placeholder="Supplement" maxlength="30">
                    @if($errors->has('supplement_code'))
                        <p class="text-danger">{{ $errors->first('supplement_code') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('supplement_type') has-error @enderror">
                <label for="supplement_type" class="control-label col-sm-4"> {{ __('supplement_type') }}</label>
                <div class="col-sm-8">
                    {!! Form::select('supplement_type', $supplement_type, $supplementInfo->supplement_type, ['id' => 'supplement_type', 'class' => 'form-control m-bot15']) !!}
                    @if($errors->has('supplement_type'))
                        <p class="text-danger">{{ $errors->first('supplement_type') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('status') has-error @enderror">
                <label for="status" class="control-label col-sm-4"> {{ __('Status') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    {!! Form::select('status', $status, $supplementInfo->status, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                    @if($errors->has('status'))
                        <p class="text-danger">{{ $errors->first('status') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
        <input type="hidden" name="supplement_id" id="supplement_id" value="{{ $supplementInfo->id }}" />
            <button type="button" id="editSupplementBtn" class="btn btn-primary" onclick="return editSupplement();">{{ __('Update Supplement') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
