<form class="form-horizontal" id="meal_plan_add_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('meal_plan_name') has-error @enderror">
                <label for="meal_plan_name" class="control-label"> {{ __('Meal Plan Name') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="meal_plan_name" id="meal_plan_name" placeholder="Meal Plan Name">
                @if($errors->has('meal_plan_name'))
                    <p class="text-danger">{{ $errors->first('meal_plan_name') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('meal_plan_name_ar') has-error @enderror">
                <label for="meal_plan_name_ar" class="control-label"> {{ __('Meal Plan Name(AR)') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="meal_plan_name_ar" id="meal_plan_name_ar" placeholder="Meal Plan Name">
                @if($errors->has('meal_plan_name_ar'))
                    <p class="text-danger">{{ $errors->first('meal_plan_name_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group @error('meal_plan_code') has-error @enderror">
        <label for="meal_plan_code" class="col-control-label"> {{ __('Meal Plan Code') }} <span class="text-danger">*</span></label>
        <input type="text" class="form-control" name="meal_plan_code" id="meal_plan_code" placeholder="Meal Plan Code">
        @if($errors->has('meal_plan_code'))
            <p class="text-danger">{{ $errors->first('meal_plan_code') }}</p>
        @endif
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('meal_plan_desc') has-error @enderror">
                <label for="meal_plan_desc" class="control-label"> {{ __('Meal Plan Desc') }}</label>
                <textarea class="form-control" name="meal_plan_desc" id="meal_plan_desc" rows="4"></textarea>
                @if($errors->has('meal_plan_desc'))
                    <p class="text-danger">{{ $errors->first('meal_plan_desc') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('meal_plan_desc_ar') has-error @enderror">
                <label for="meal_plan_desc_ar" class="control-label"> {{ __('Meal Plan Desc(AR)') }}</label>
                <textarea class="form-control" name="meal_plan_desc_ar" id="meal_plan_desc_ar" rows="4"></textarea>
                @if($errors->has('meal_plan_desc_ar'))
                    <p class="text-danger">{{ $errors->first('meal_plan_desc_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('status') has-error @enderror">
                <label for="status" class="control-label"> {{ __('Status') }}</label>
                {!! Form::select('status', $status, null, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('status'))
                    <p class="text-danger">{{ $errors->first('status') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
            <button type="button" id="addMealPlanBtn" class="btn btn-primary" onclick="return addMealPlan();">{{ __('Add Meal Plan') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
