<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactType;
use DataTables;
use Validator;

class ContactTypeController extends Controller
{
    public function __construct()
    {
        $this->contactTypeStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            
            $results = ContactType::isNotDeleted()->get();

            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("contact_type_name", function ($data) {
                    if (empty($data->contact_type_name)) {
                        return "N/A";
                    }
                    return $data->contact_type_name;
                })
                ->addColumn("contact_type_code", function ($data) {
                    if (empty($data->contact_type_code)) {
                        return "N/A";
                    }
                    return $data->contact_type_code;
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-sm btn-info">Action</button>
                        <button type="button" class="btn btn-sm btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletecontacttype" href="javascript:;" data-contact-type="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }

        $data["title"] = "Manage Contact Type";

        return view("pages.admin.contact-type.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {       
        $data["status"] = $this->contactTypeStatus;
        return view('pages.admin.contact-type.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $contactTypeInfo = ContactType::find($id);
        $data["contactTypeInfo"] = $contactTypeInfo;
        $data["status"] = $this->contactTypeStatus;
        return view('pages.admin.contact-type.edit',$data);   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $contactType = ContactType::find($request->id);
        $contactType->is_deleted = 1;
        $contactType->deleted_at = date('Y-m-d H:i:s');
        $contactType->save();
        // $contactType->delete();
        return response()->json(['status' => 'success', 'message' => 'Contact Type information deleted successfully', 'error' => ''], 200);
        return 1;
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->contactTypeStatus;
        return view('pages.admin.contact-type.ajaxAdd',$data);
    }

    public function addContactType(Request $request)
    {
        $messages = array(
                    'contact_type_name.required' => 'Contact Type Name is Required',
                    'contact_type_name_ar.required' => 'Contact Type Name(AR) is Required',
                );
        $validator = Validator::make($request->all(), ['contact_type_name' => 'required', 'contact_type_name_ar' => 'required'], $messages);
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $contactType = ContactType::create([            
                "contact_type_name" => trim($request->contact_type_name),
                "contact_type_name_ar" => trim($request->contact_type_name_ar),
                "contact_type_code" => trim($request->contact_type_code),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Contact Type added successfully.', 'error' => ''], 200);
        }
    }

    public function ajaxEdit(Request $request)
    {
        $contactTypeInfo = ContactType::find($request->contact_type_id);
        $data["contactTypeInfo"] = $contactTypeInfo;
        $data["status"] = $this->contactTypeStatus;
        return view('pages.admin.contact-type.ajaxEdit',$data);
    }

    public function editContactType(Request $request)
    {
        $messages = array(
                    'contact_type_name.required' => 'Contact Type Name is Required',
                    'contact_type_name_ar.required' => 'Contact Type Name(AR) is Required',
                );
        $validator = Validator::make($request->all(), ['contact_type_name' => 'required', 'contact_type_name_ar' => 'required'], $messages);
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $contactType = ContactType::find($request->contact_type_id);
            $contactType->contact_type_name = trim($request->contact_type_name);
            $contactType->contact_type_name_ar = trim($request->contact_type_name_ar);
            $contactType->contact_type_code = trim($request->contact_type_code);
            $contactType->status = trim($request->status);
            $contactType->save();

            return response()->json(['status' => 'success', 'message' => 'Contact Type updated successfully.', 'error' => ''], 200);
        }
    }
}
