<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
    // return view('welcome');
});
Route::get('qr-code-g', function () {
    
  return view('qrCode');
    
});
Route::get('qr-code-test', function (){
    return view('qr-code-test');
});
Auth::routes();

Route::get('file-import-export', [App\Http\Controllers\Test\ImportExportController::class, 'fileImportExport']);
Route::post('file-import', [App\Http\Controllers\Test\ImportExportController::class, 'fileImport'])->name('file-import');
Route::get('file-export', [App\Http\Controllers\Test\ImportExportController::class, 'fileExport'])->name('file-export');
Route::get('phone-auth', [App\Http\Controllers\Auth\PhoneAuthController::class, 'index']);

Route::group(['middleware' => ['auth','XSS','web']], function() {
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::resource('/user', App\Http\Controllers\Admin\UserController::class);
    Route::post('/delete-user', [App\Http\Controllers\Admin\UserController::class,'destroy'])->name('delete-user');
    Route::post('/user/get-supplier-service', [App\Http\Controllers\Admin\UserController::class,'getSupplierServiceList'])->name('user.getSupplierServiceList');

    Route::resource('/role', App\Http\Controllers\Admin\RoleController::class);
    Route::post('/delete-role', [App\Http\Controllers\Admin\RoleController::class,'destroy'])->name('delete-role');

    Route::resource('/contact-type', App\Http\Controllers\Admin\ContactTypeController::class);
    Route::post('/delete-contact-type', [App\Http\Controllers\Admin\ContactTypeController::class,'destroy'])->name('delete-contact-type');
    Route::post('/contact-type-ajax-add', [App\Http\Controllers\Admin\ContactTypeController::class,'ajaxAdd'])->name('contact-type.ajax-add');
    Route::post('/contact-type/add-contact-type', [App\Http\Controllers\Admin\ContactTypeController::class,'addContactType'])->name('contact-type.addContactType');
    Route::post('/contact-type-ajax-edit', [App\Http\Controllers\Admin\ContactTypeController::class,'ajaxEdit'])->name('contact-type.ajax-edit');
    Route::post('/contact-type/edit-contact-type', [App\Http\Controllers\Admin\ContactTypeController::class,'editContactType'])->name('contact-type.editContactType');

    Route::resource('/image-name', App\Http\Controllers\Admin\ImageNameController::class);
    Route::post('/delete-image-name', [App\Http\Controllers\Admin\ImageNameController::class,'destroy'])->name('delete-image-name');
    Route::post('/image-name-ajax-add', [App\Http\Controllers\Admin\ImageNameController::class,'ajaxAdd'])->name('image-name.ajax-add');
    Route::post('/image-name-add-image-name', [App\Http\Controllers\Admin\ImageNameController::class,'addImageName'])->name('image-name.addImageName');
    Route::post('/image-name-ajax-edit', [App\Http\Controllers\Admin\ImageNameController::class,'ajaxEdit'])->name('image-name.ajax-edit');
    Route::post('/image-name-edit-image-name', [App\Http\Controllers\Admin\ImageNameController::class,'editImageName'])->name('image-name.editImageName');

    Route::resource('/supplement', App\Http\Controllers\Admin\SupplementController::class);
    Route::post('/delete-supplement', [App\Http\Controllers\Admin\SupplementController::class,'destroy'])->name('delete-supplement');
    Route::post('/supplement-ajax-add', [App\Http\Controllers\Admin\SupplementController::class,'ajaxAdd'])->name('supplement.ajax-add');
    Route::post('/supplement/add-supplement', [App\Http\Controllers\Admin\SupplementController::class,'addSupplement'])->name('supplement.addSupplement');
    Route::post('/supplement-ajax-edit', [App\Http\Controllers\Admin\SupplementController::class,'ajaxEdit'])->name('supplement.ajax-edit');
    Route::post('/supplement/edit-supplement', [App\Http\Controllers\Admin\SupplementController::class,'editSupplement'])->name('supplement.editSupplement');

    Route::resource('/room-category', App\Http\Controllers\Admin\RoomCategoryController::class);
    Route::post('/delete-room-category', [App\Http\Controllers\Admin\RoomCategoryController::class,'destroy'])->name('delete-room-category');
    Route::post('/room-category-ajax-add', [App\Http\Controllers\Admin\RoomCategoryController::class,'ajaxAdd'])->name('room-category.ajax-add');
    Route::post('/room-category/add-room-category', [App\Http\Controllers\Admin\RoomCategoryController::class,'addRoomCategory'])->name('room-category.addRoomCategory');
    Route::post('/room-category-ajax-edit', [App\Http\Controllers\Admin\RoomCategoryController::class,'ajaxEdit'])->name('room-category.ajax-edit');
    Route::post('/room-category/edit-room-category', [App\Http\Controllers\Admin\RoomCategoryController::class,'editRoomCategory'])->name('room-category.editRoomCategory');

    Route::resource('/hotel-category', App\Http\Controllers\Admin\HotelCategoryController::class);
    Route::post('/delete-hotel-category', [App\Http\Controllers\Admin\HotelCategoryController::class,'destroy'])->name('delete-hotel-category');
    Route::post('/hotel-category-ajax-add', [App\Http\Controllers\Admin\HotelCategoryController::class,'ajaxAdd'])->name('hotel-category.ajax-add');
    Route::post('/hotel-category/add-hotel-category', [App\Http\Controllers\Admin\HotelCategoryController::class,'addHotelCategory'])->name('hotel-category.addHotelCategory');
    Route::post('/hotel-category-ajax-edit', [App\Http\Controllers\Admin\HotelCategoryController::class,'ajaxEdit'])->name('hotel-category.ajax-edit');
    Route::post('/hotel-category/edit-hotel-category', [App\Http\Controllers\Admin\HotelCategoryController::class,'editHotelCategory'])->name('hotel-category.editHotelCategory');

    Route::resource('/hotel-facility', App\Http\Controllers\Admin\HotelFacilityController::class);
    Route::post('/delete-hotel-facility', [App\Http\Controllers\Admin\HotelFacilityController::class,'destroy'])->name('delete-hotel-facility');
    Route::post('/hotel-facility-ajax-add', [App\Http\Controllers\Admin\HotelFacilityController::class,'ajaxAdd'])->name('hotel-facility.ajax-add');
    Route::post('/hotel-facility/add-hotel-facility', [App\Http\Controllers\Admin\HotelFacilityController::class,'addHotelFacility'])->name('hotel-facility.addHotelFacility');
    Route::post('/hotel-facility-ajax-edit', [App\Http\Controllers\Admin\HotelFacilityController::class,'ajaxEdit'])->name('hotel-facility.ajax-edit');
    Route::post('/hotel-facility/edit-hotel-facility', [App\Http\Controllers\Admin\HotelFacilityController::class,'editHotelFacility'])->name('hotel-facility.editHotelFacility');

    Route::resource('/room-facility', App\Http\Controllers\Admin\RoomFacilityController::class);
    Route::post('/delete-room-facility', [App\Http\Controllers\Admin\RoomFacilityController::class,'destroy'])->name('delete-room-facility');
    Route::post('/room-facility-ajax-add', [App\Http\Controllers\Admin\RoomFacilityController::class,'ajaxAdd'])->name('room-facility.ajax-add');
    Route::post('/room-facility/add-room-facility', [App\Http\Controllers\Admin\RoomFacilityController::class,'addRoomFacility'])->name('room-facility.addRoomFacility');
    Route::post('/room-facility-ajax-edit', [App\Http\Controllers\Admin\RoomFacilityController::class,'ajaxEdit'])->name('room-facility.ajax-edit');
    Route::post('/room-facility/edit-room-facility', [App\Http\Controllers\Admin\RoomFacilityController::class,'editRoomFacility'])->name('room-facility.editRoomFacility');

    Route::resource('/meal-plan', App\Http\Controllers\Admin\MealPlanController::class);
    Route::post('/delete-meal-plan', [App\Http\Controllers\Admin\MealPlanController::class,'destroy'])->name('delete-meal-plan');
    Route::post('/meal-plan-ajax-add', [App\Http\Controllers\Admin\MealPlanController::class,'ajaxAdd'])->name('meal-plan.ajax-add');
    Route::post('/meal-plan/add-meal-plan', [App\Http\Controllers\Admin\MealPlanController::class,'addMealPlan'])->name('meal-plan.addMealPlan');
    Route::post('/meal-plan-ajax-edit', [App\Http\Controllers\Admin\MealPlanController::class,'ajaxEdit'])->name('meal-plan.ajax-edit');
    Route::post('/meal-plan/edit-meal-plan', [App\Http\Controllers\Admin\MealPlanController::class,'editMealPlan'])->name('meal-plan.editMealPlan');

    Route::resource('/location', App\Http\Controllers\Admin\LocationController::class);
    Route::post('/delete-location', [App\Http\Controllers\Admin\LocationController::class,'destroy'])->name('delete-location');
    Route::post('/location-ajax-add', [App\Http\Controllers\Admin\LocationController::class,'ajaxAdd'])->name('location.ajax-add');
    Route::post('/location/add-location', [App\Http\Controllers\Admin\LocationController::class,'addLocation'])->name('location.addLocation');
    Route::post('/location-ajax-edit', [App\Http\Controllers\Admin\LocationController::class,'ajaxEdit'])->name('location.ajax-edit');
    Route::post('/location/edit-location', [App\Http\Controllers\Admin\LocationController::class,'editLocation'])->name('location.editLocation');
    
    Route::resource('/market', App\Http\Controllers\Admin\MarketController::class);
    Route::post('/delete-market', [App\Http\Controllers\Admin\MarketController::class,'destroy'])->name('delete-market');
    Route::post('/market-ajax-add', [App\Http\Controllers\Admin\MarketController::class,'ajaxAdd'])->name('market.ajax-add');
    Route::post('/market/add-market', [App\Http\Controllers\Admin\MarketController::class,'addMarket'])->name('market.addMarket');
    Route::post('/market-ajax-edit', [App\Http\Controllers\Admin\MarketController::class,'ajaxEdit'])->name('market.ajax-edit');
    Route::post('/market/edit-market', [App\Http\Controllers\Admin\MarketController::class,'editMarket'])->name('market.editMarket');


    Route::resource('/hotel', App\Http\Controllers\Admin\HotelController::class);
    Route::resource('/sightseeing', App\Http\Controllers\Admin\SightseeingController::class);
    Route::resource('/transfer', App\Http\Controllers\Admin\TransferController::class);
    Route::resource('/fixed-package', App\Http\Controllers\Admin\FixedPackageController::class);
    Route::resource('/dynamic-package', App\Http\Controllers\Admin\DynamicPackageController::class);
    Route::resource('/flight', App\Http\Controllers\Admin\FlightController::class);

    Route::resource('/supplier', App\Http\Controllers\Admin\SupplierController::class);
    Route::post('/delete-supplier', [App\Http\Controllers\Admin\SupplierController::class,'destroy'])->name('delete-supplier');
    Route::post('/supplier-get-change-approve-status-form', [App\Http\Controllers\Admin\SupplierController::class,'getChangeApproveStatusForm'])->name('supplier.getChangeApproveStatusForm');
    Route::post('/supplier-change-approve-status', [App\Http\Controllers\Admin\SupplierController::class,'changeApproveStatus'])->name('supplier.changeApproveStatus');
    Route::post('/supplier-ajax-service-form', [App\Http\Controllers\Admin\SupplierController::class,'serviceForm'])->name('supplier.serviceForm');
    Route::post('/supplier/save-service', [App\Http\Controllers\Admin\SupplierController::class,'saveService'])->name('supplier.saveService');
    
    Route::resource('/setting', App\Http\Controllers\Admin\SettingController::class);
    Route::post('/admin-setting', [App\Http\Controllers\Admin\SettingController::class,'updateAdminSetting'])->name('admin.setting');
    Route::post('/delete-setting', [App\Http\Controllers\Admin\SettingController::class,'destroy'])->name('delete-setting');
    Route::post('/setting-ajax-edit', [App\Http\Controllers\Admin\SettingController::class,'ajaxEdit'])->name('setting.ajax-edit');
    
    
    Route::get('/edit-profile-form', [App\Http\Controllers\Admin\UserController::class,'editProfileForm'])->name('edit-profile-form');
	
});



