<form class="form-horizontal" id="room_category_edit_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('room_category_name') has-error @enderror">
                <label for="room_category_name" class="control-label"> {{ __('Hotel Category Name') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="room_category_name" id="room_category_name" value="{{ $roomCategoryInfo->room_category_name }}" placeholder="Hotel Category Name" required>
                @if($errors->has('room_category_name'))
                    <p class="text-danger">{{ $errors->first('room_category_name') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('room_category_name_ar') has-error @enderror">
                <label for="room_category_name_ar" class="control-label"> {{ __('Hotel Category Name(AR)') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="room_category_name_ar" id="room_category_name_ar" value="{{ $roomCategoryInfo->room_category_name_ar }}" placeholder="Hotel Category Name" required>
                @if($errors->has('room_category_name_ar'))
                    <p class="text-danger">{{ $errors->first('room_category_name_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group @error('room_category_code') has-error @enderror">
        <label for="room_category_code" class="col-control-label"> {{ __('Hotel Category Code') }} <span class="text-danger">*</span></label>
        <input type="text" class="form-control" name="room_category_code" id="room_category_code" value="{{ $roomCategoryInfo->room_category_code }}" placeholder="Hotel Category Code" required>
        @if($errors->has('room_category_code'))
            <p class="text-danger">{{ $errors->first('room_category_code') }}</p>
        @endif
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('room_category_desc') has-error @enderror">
                <label for="room_category_desc" class="control-label"> {{ __('Hotel Category Desc') }}</label>
                <textarea class="form-control" name="room_category_desc" id="room_category_desc" rows="4">{{ $roomCategoryInfo->room_category_desc }}</textarea>
                @if($errors->has('room_category_desc'))
                    <p class="text-danger">{{ $errors->first('room_category_desc') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('room_category_desc_ar') has-error @enderror">
                <label for="room_category_desc_ar" class="control-label"> {{ __('Hotel Category Desc(AR)') }}</label>
                <textarea class="form-control" name="room_category_desc_ar" id="room_category_desc_ar" rows="4">{{ $roomCategoryInfo->room_category_desc_ar }}</textarea>
                @if($errors->has('room_category_desc_ar'))
                    <p class="text-danger">{{ $errors->first('room_category_desc_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('status') has-error @enderror">
                <label for="status" class="control-label"> {{ __('Status') }} <span class="text-danger">*</span></label>
                {!! Form::select('status', $status, $roomCategoryInfo->status, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('status'))
                    <p class="text-danger">{{ $errors->first('status') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
        <input type="hidden" name="room_category_id" id="room_category_id" value="{{ $roomCategoryInfo->id }}" />
            <button type="button" id="editRoomCategoryBtn" class="btn btn-primary" onclick="return editRoomCategory();">{{ __('Update Room Category') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
