@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('market') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Market') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Market') }}</h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Market') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="market_table">
                        <thead>
                            <tr>
                                <th>{{ __('Market Name') }}</th>
                                <th>{{ __('Market Code') }}</th> 
                                <th>{{ __('Priority') }}</th> 
                                <th>{{ __('Status') }}</th> 
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#market_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('market.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'market_name', name: 'market_name'},
            {data: 'market_code', name: 'market_code'}, 
            {data: 'priority', name: 'priority'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletemarket').on('click',function(){
              var x = confirm("Do you want to delete the Market?");
              if(x == true) { 
              var imagenameid = $(this).data('market'); 
                  $.ajax({
                        url: "{{ route('delete-market') }}",
                        data: { "id": imagenameid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                toastr.success(data.message, 'Success');
                                $('#market_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "{{ route('market.ajax-add') }}",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Add Market' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function addMarket()
{
    var market_name = $('#market_add_form #market_name').val();
    var market_name_ar = $('#market_add_form #market_name_ar').val();
    var market_code = $('#market_add_form #market_code').val();
    var priority = $('#market_add_form #priority').val();
    var associated_countries = $('#market_add_form #associated_countries').val();
    var status = $('#market_add_form #status').val();
    var isValid = 1;
    if (market_name == "") {
        toastr.error('Please enter market name','Error');
        isValid = 0;
    }
    if (market_name_ar == "") {
        toastr.error('Please enter market name(AR)','Error');
        isValid = 0;
    }
    if(isValid){
        $.ajax({
            url: "{{ route('market.addMarket') }}",
            data: { "market_name": market_name, "market_name_ar": market_name_ar, "market_code": market_code, "priority": priority, "associated_countries": associated_countries, "status": status,},
            type: "post",
            dataType: "json",
            beforeSend: function() { 
                $("#addMarketBtn").prop('disabled', true);
            },
            success: function (res) {
                $("#addMarketBtn").prop('disabled', false);
                if(res.status == 'failed'){
                    if(res.error){
                        $.each(res.error, function(i, item) {
                            toastr.error(item[0],'Error');
                        });
                    }else{
                        toastr.error('Some problem found. Please try again.','Error');
                    }
                }else{
                    $('#market_add_form')[0].reset();
                    toastr.success(res.message, 'Success');
                    $('#market_table').DataTable().ajax.reload();
                    $("#modal_lg").modal("hide");
                }
            },
            error: function(xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        });
    }
}
function ajaxEdit(market_id){
    $.ajax({
        url: "{{ route('market.ajax-edit') }}",
        data: {"market_id": market_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Edit Market' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function editMarket()
{
    var market_name = $('#market_edit_form #market_name').val();
    var market_name_ar = $('#market_edit_form #market_name_ar').val();
    var market_code = $('#market_edit_form #market_code').val();
    var priority = $('#market_edit_form #priority').val();
    var associated_countries = $('#market_edit_form #associated_countries').val();
    var status = $('#market_edit_form #status').val();
    var market_id = $('#market_edit_form #market_id').val();
    var isValid = 1;
    if (market_name == "") {
        toastr.error('Please enter market name','Error');
        isValid = 0;
    }
    if (market_name_ar == "") {
        toastr.error('Please enter market name(AR)','Error');
        isValid = 0;
    }
    if(isValid){
        $.ajax({
            url: "{{ route('market.editMarket') }}",
            data: { "market_name": market_name, "market_name_ar": market_name_ar, "market_code": market_code, "priority": priority, "associated_countries": associated_countries, "status": status, "market_id": market_id},
            type: "post",
            dataType: "json",
            beforeSend: function() { 
                $("#editMarketBtn").prop('disabled', true);
            },
            success: function (res) {
                $("#editMarketBtn").prop('disabled', false);
                if(res.status == 'failed'){
                    if(res.error){
                        $.each(res.error, function(i, item) {
                            toastr.error(item[0],'Error');
                        });
                    }else{
                        toastr.error('Some problem found. Please try again.','Error');
                    }
                }else{
                    toastr.success(res.message, 'Success');
                    $('#market_table').DataTable().ajax.reload();
                    $("#modal_lg").modal("hide");
                }
            },
            error: function(xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        });
    }
}
</script>
@endsection