<form class="form-horizontal" id="hotel_category_add_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('hotel_category_name') has-error @enderror">
                <label for="hotel_category_name" class="control-label"> {{ __('Hotel Category Name') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="hotel_category_name" id="hotel_category_name" placeholder="Hotel Category Name">
                @if($errors->has('hotel_category_name'))
                    <p class="text-danger">{{ $errors->first('hotel_category_name') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('hotel_category_name_ar') has-error @enderror">
                <label for="hotel_category_name_ar" class="control-label"> {{ __('Hotel Category Name(AR)') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="hotel_category_name_ar" id="hotel_category_name_ar" placeholder="Hotel Category Name">
                @if($errors->has('hotel_category_name_ar'))
                    <p class="text-danger">{{ $errors->first('hotel_category_name_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group @error('hotel_category_code') has-error @enderror">
        <label for="hotel_category_code" class="col-control-label"> {{ __('Hotel Category Code') }} <span class="text-danger">*</span></label>
        <input type="text" class="form-control" name="hotel_category_code" id="hotel_category_code" placeholder="Hotel Category Code" required>
        @if($errors->has('hotel_category_code'))
            <p class="text-danger">{{ $errors->first('hotel_category_code') }}</p>
        @endif
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('hotel_category_desc') has-error @enderror">
                <label for="hotel_category_desc" class="control-label"> {{ __('Hotel Category Desc') }}</label>
                <textarea class="form-control" name="hotel_category_desc" id="hotel_category_desc" rows="4"></textarea>
                @if($errors->has('hotel_category_desc'))
                    <p class="text-danger">{{ $errors->first('hotel_category_desc') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('hotel_category_desc_ar') has-error @enderror">
                <label for="hotel_category_desc_ar" class="control-label"> {{ __('Hotel Category Desc(AR)') }}</label>
                <textarea class="form-control" name="hotel_category_desc_ar" id="hotel_category_desc_ar" rows="4"></textarea>
                @if($errors->has('hotel_category_desc_ar'))
                    <p class="text-danger">{{ $errors->first('hotel_category_desc_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('status') has-error @enderror">
                <label for="status" class="control-label"> {{ __('Status') }} <span class="text-danger">*</span></label>
                {!! Form::select('status', $status, null, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('status'))
                    <p class="text-danger">{{ $errors->first('status') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
            <button type="button" id="addHotelCategoryBtn" class="btn btn-primary" onclick="return addHotelCategory();">{{ __('Add Hotel Category') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
