<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Supplier\StoreSupplierRequest;
use App\Http\Requests\Supplier\UpdateSupplierRequest;
use Illuminate\Http\Request;
use App\Models\Supplier; 
use App\Models\Service;
use App\Models\SupplierService;
use App\Models\Country;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\QueryException;
use Spatie\Permission\Models\Role;
use DataTables;
use Validator;
use Session;

class SupplierController extends Controller
{
    public function __construct()
    {
        $this->userStatus = ["1" => "Active", "2" => "Inactive"];
        $this->defaultPassword = "Extra@123";
        $this->isApproved = ["0" => "Pending", "1" => "Approved","2"=>"Rejected"];
        $this->supplierStatus = ["1" => "Active", "2" => "Inactive"];
        $this->approvedStatus = ["0" => "Pending", "1" => "Approved", "2" => "Rejected"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
            
        if ($request->ajax()) {
            
            $results = Supplier::isNotDeleted()->get();

            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("contractor_first_name", function ($data) {
                    if (empty($data->contractor_first_name)) {
                        return "N/A";
                    }
                    return $data->contractor_first_name;
                })
                ->addColumn("supplier_company", function ($data) {
                    if (empty($data->supplier_company)) {
                        return "N/A";
                    }
                    return $data->supplier_company;
                })
                ->addColumn("supplier_code", function ($data) {
                    if (empty($data->supplier_code)) {
                        return "N/A";
                    }
                    return $data->supplier_code;
                })
                ->addColumn("email", function ($data) {
                    if (empty($data->email)) {
                        return "N/A";
                    }
                    return $data->email;
                })
                ->addColumn("is_approved", function ($data) {
                    if($data->user->is_approved == 1)
                    {
                        return '<span class="badge bg-success">'.$this->isApproved[$data->user->is_approved].'</span>';
                    }
                    else if($data->user->is_approved == 2)
                    {
                        return '<span class="badge bg-warning">'.$this->isApproved[$data->user->is_approved].'</span>';
                    }
                    else
                    {
                        return '<span class="badge bg-danger">'.$this->isApproved[$data->user->is_approved].'</span>';
                    }
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-sm btn-info">Action</button>
                        <button type="button" class="btn btn-sm btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="' . route("supplier.edit", $data->supplier_id) . '">Edit</a>
                          <a class="dropdown-item deletesupplement" href="javascript:;" data-Supplier="' . $data->supplier_id . '">Delete</a>
                          <a class="dropdown-item deletesupplement" href="javascript:;" onclick="return ajaxSaveService('.$data->user->id.');">Services</a>
                          <a class="dropdown-item deletesupplement" href="javascript:;" onclick="return getChangeApproveStatusForm('.$data->user->id.','.$data->user->is_approved.');">Change Approve Status</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["is_approved", "action"])
                ->make(true);
        }

        $data["title"] = "Manage Supplier";

        return view("pages.admin.supplier.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data["roles"] = Role::all();
        $data["password"] = $this->defaultPassword;
        $data["namePrefix"] = array('1' => 'Mr', '2' => 'Mrs');
        $data["status"] = $this->supplierStatus;
        $data["countries"] = Country::get();
        return view('pages.admin.supplier.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreSupplierRequest $request)
    {
        try
        {
            $user_id = User::createUser($request,'SUPPLIER');
            if($user_id)
            {
                try
                {   if ( ! $request->has('hotel_confirmation')) { $hotel_confirmation = 0; }else{ $hotel_confirmation = 1; }
                    $supplier = Supplier::create([
                        "supplier_company" => trim($request->supplier_company),
                        "user_id" => $user_id,
                        "supplier_code" => trim($request->supplier_code),
                        "name_prefix" => trim($request->name_prefix),
                        "contractor_first_name" => trim($request->contractor_first_name),
                        "contractor_last_name" => trim($request->contractor_last_name),
                        "supplier_ref" => trim($request->supplier_ref),
                        "license_number" => trim($request->license_number),
                        "address" => trim($request->address),
                        "country_id" => trim($request->country_id),
                        "state" => trim($request->state),
                        "city" => trim($request->city),
                        "postal_code" => trim($request->postal_code),
                        "phone" => trim($request->phone),
                        "email" => trim($request->email),
                        "pan_number" => trim($request->pan_number),
                        "tan_number" => trim($request->tan_number),
                        "service_tax_number" => trim($request->service_tax_number),
                        "iata_no" => trim($request->iata_no),
                        "tta_no" => trim($request->tta_no),
                        "fax_number" => trim($request->fax_number),
                        "hotel_confirmation" => trim($hotel_confirmation),
                        "status" => trim($request->status),
                        "created_by" => \Auth::user()->id
                    ]);
                }
                catch(QueryException $ex) 
                {
                    //dd($ex); exit;
                    return redirect()
                    ->route("supplier.index")
                    ->with("failed", "Insertion Error");                 
                }
            }
        }
        catch(QueryException $ex) 
        {
            //dd($ex); exit;
            return redirect()
            ->route("supplier.index")
            ->with("failed","User Insertion Error");                 
        }
        return redirect()
        ->route("supplier.index")
        ->with("success", "Supplier created successfully!");
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $supplierInfo = Supplier::find($id);
        $data["supplierInfo"] = $supplierInfo;
        $data["namePrefix"] = array('1' => 'Mr', '2' => 'Mrs');
        $data["status"] = $this->supplierStatus;
        $data["countries"] = Country::get();
        return view('pages.admin.supplier.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateSupplierRequest $request, $id)
    {
        try
        {
            $user_id = User::updateUser($request);
            if($user_id)
            {
                try
                {   if ( ! $request->has('hotel_confirmation')) { $hotel_confirmation = 0; }else{ $hotel_confirmation = 1; }
                    $supplier = Supplier::find($id);
                    $supplier->supplier_company = trim($request->supplier_company);
                    $supplier->supplier_code = trim($request->supplier_code);
                    $supplier->name_prefix = trim($request->name_prefix);
                    $supplier->contractor_first_name = trim($request->contractor_first_name);
                    $supplier->contractor_last_name = trim($request->contractor_last_name);
                    $supplier->supplier_ref = trim($request->supplier_ref);
                    $supplier->license_number = trim($request->license_number);
                    $supplier->address = trim($request->address);
                    $supplier->country_id = trim($request->country_id);
                    $supplier->state = trim($request->state);
                    $supplier->city = trim($request->city);
                    $supplier->postal_code = trim($request->postal_code);
                    $supplier->phone = trim($request->phone);
                    $supplier->email = trim($request->email);
                    $supplier->pan_number = trim($request->pan_number);
                    $supplier->tan_number = trim($request->tan_number);
                    $supplier->service_tax_number = trim($request->service_tax_number);
                    $supplier->iata_no = trim($request->iata_no);
                    $supplier->tta_no = trim($request->tta_no);
                    $supplier->fax_number = trim($request->fax_number);
                    $supplier->hotel_confirmation = trim($hotel_confirmation);
                    $supplier->status = trim($request->status);
                    $supplier->save();
                }
                catch(QueryException $ex) 
                {
                    return redirect()
                    ->route("supplier.index")
                    ->with("failed", "Insertion Error");                 
                }
            }
        }
        catch(QueryException $ex) 
        {
            //dd($ex);
            return redirect()
            ->route("supplier.index")
            ->with("failed","User Insertion Error");          
        }
        return redirect()
        ->route("supplier.index")
        ->with("success", "Supplier updated successfully!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $user = User::find($request->id);
        $user->delete();
        Session::flash("success", "Supplier information deleted successfully.");
        return 1;
    }

    public function getChangeApproveStatusForm(Request $request){
        $data = array();
        $data['approveStatusLists'] = $this->approvedStatus;
        $data['is_approved'] = $request->is_approved;
        $data['user_id'] = $request->user_id;
        return view('pages.admin.supplier.change_approve_status_form', $data);
    }

    public function changeApproveStatus(Request $request)
    {
        $messages = ['is_approved.required' => 'Approve Status is Required'];

        $validator = Validator::make($request->all(), ['is_approved' => 'required|numeric'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $user_id = $request->user_id;
            User::Where('id', $user_id)->update(array('is_approved' => $request->is_approved, 'updated_at' => date('Y-m-d H:i:s')));
            Session::flash('success', 'Approve Status updated successfully.');
            return response()->json(['status' => 'success', 'message' => 'Approve Status updated successfully.', 'error' => ''], 200);

        }
    }
    public function serviceForm(Request $request)
    {
        $data["user_id"] = $request->user_id;
        $data["serviceList"] = Service::get();
        $data["serviceCount"] = Service::count();
        $data["supplierServiceCount"] = SupplierService::where('user_id',$request->user_id)->count();
        return view('pages.admin.supplier.ajaxSaveService',$data);
    }

    public function saveService(Request $request)
    {
        $messages = array(
                    'user_id.required' => 'User ID is Required'
                );
        $validator = Validator::make($request->all(), ['user_id' => 'required'], $messages);
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            SupplierService::Where('user_id', $request->user_id)->delete();
            $service_ids = $request->service_name;
            if($service_ids){
                foreach($service_ids as $service_id) {
                    SupplierService::updateOrCreate(['service_id' => $service_id, 'user_id' => $request->user_id],['service_id' => $service_id, 'user_id' => $request->user_id]);
                }
            }
            return response()->json(['status' => 'success', 'message' => 'Supplier Services saved successfully.', 'error' => ''], 200);
        }
    }
}
