<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HotelFacility;
use DataTables;
use Validator;

class HotelFacilityController extends Controller
{
    public function __construct()
    {
        $this->hotelFacilityStatus = ["1" => "Active", "2" => "Inactive"];
        $this->hotelSectionType = ["1" => "Sec 1", "2" => "Sec 2"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = HotelFacility::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("hotel_facility_name", function ($data) {
                    if (empty($data->hotel_facility_name)) {
                        return "N/A";
                    }
                    return $data->hotel_facility_name;
                })
                ->addColumn("hotel_facility_code", function ($data) {
                    if (empty($data->hotel_facility_code)) {
                        return "N/A";
                    }
                    return $data->hotel_facility_code;
                })
                ->addColumn("hotel_section_type", function ($data) {
                    if (empty($data->hotel_section_type)) {
                        return "N/A";
                    }
                    return $this->hotelSectionType[$data->hotel_section_type];
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-info">Action</button>
                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletehotelfacility" href="javascript:;" data-hotel-facility="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Hotel Facility";
        return view("pages.admin.hotel-facility.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $hotelFacility = HotelFacility::find($request->id);
        $hotelFacility->is_deleted = 1;
        $hotelFacility->deleted_at = date('Y-m-d H:i:s');
        $hotelFacility->save();
        //$hotelFacility->delete();
        return response()->json(['status' => 'success', 'message' => 'Hotel Facility information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->hotelFacilityStatus;
        $data["sectionType"] = $this->hotelSectionType;
        return view('pages.admin.hotel-facility.ajaxAdd',$data);
    }
    public function addHotelFacility(Request $request)
    {
        $messages = array(
                        'hotel_facility_name.required' => 'Hotel Facility Name is Required',
                        'hotel_facility_name_ar.required' => 'Hotel Facility Name(AR) is Required',
                        'hotel_facility_code.required' => 'Hotel Facility Code is Required',
                    );
        $validator = Validator::make($request->all(), [
                                                'hotel_facility_name' => 'required',
                                                'hotel_facility_name_ar' => 'required',
                                                'hotel_facility_code' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $ImageName = HotelFacility::create([  
                "hotel_facility_name" => trim($request->hotel_facility_name),
                "hotel_facility_name_ar" => trim($request->hotel_facility_name_ar),
                "hotel_facility_code" => trim($request->hotel_facility_code),
                "hotel_section_type" => trim($request->hotel_section_type),
                "hotel_facility_desc" => trim($request->hotel_facility_desc),
                "hotel_facility_desc_ar" => trim($request->hotel_facility_desc_ar),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Hotel Facility added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $hotelFacilityInfo = HotelFacility::find($request->hotel_facility_id);
        $data["hotelFacilityInfo"] = $hotelFacilityInfo;
        $data["status"] = $this->hotelFacilityStatus;
        $data["sectionType"] = $this->hotelSectionType;
        return view('pages.admin.hotel-facility.ajaxEdit',$data);
    }
    public function editHotelFacility(Request $request)
    {
        $messages = array(
            'hotel_facility_name.required' => 'Hotel Facility Name is Required',
            'hotel_facility_name_ar.required' => 'Hotel Facility Name(AR) is Required',
            'hotel_facility_code.required' => 'Hotel Facility Code is Required',
        );
        $validator = Validator::make($request->all(), [
                                                'hotel_facility_name' => 'required',
                                                'hotel_facility_name_ar' => 'required',
                                                'hotel_facility_code' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $hotelFacility = HotelFacility::find($request->hotel_facility_id);
            $hotelFacility->hotel_facility_name = $request->hotel_facility_name;
            $hotelFacility->hotel_facility_name_ar = $request->hotel_facility_name_ar;
            $hotelFacility->hotel_facility_code = $request->hotel_facility_code;
            $hotelFacility->hotel_section_type = $request->hotel_section_type;
            $hotelFacility->hotel_facility_desc = $request->hotel_facility_desc;
            $hotelFacility->hotel_facility_desc_ar = $request->hotel_facility_desc_ar;
            $hotelFacility->status = $request->status;
            $hotelFacility->save();

            return response()->json(['status' => 'success', 'message' => 'Hotel Facility updated successfully.', 'error' => ''], 200);
        }
    }
}
