<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Order;
use App\Models\OrderSchedule;
use DB;

class OrderScheduleCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order_schedule:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Order Schedule';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // try{
            DB::transaction(function()
            {
               
                $orders = Order::with('pickupAddress')->where('order_scheduled','=',0)->orderBy('pickup_address_book_id')->get();
                \Log::info("orderschedule".$orders);
                if(count($orders) > 0)
                {
                    foreach($orders as $order)
                    {
                        $orderSchedule =OrderSchedule::createOrderSchedule($order);
                    }
                }
                else
                {
                    dd("Insert Error :");
                }
            });
        // }
        // catch(\Exception $e)
        // {
        //     DB::rollback();
        // }
    }
}
