<?php

namespace App\Console\Commands;

use App\Models\OrderGrouping;
use Illuminate\Console\Command;
use App\Models\OrderGroupingAddress;
use App\Models\OrderSchedule;
use DB;

class OrderGroupingAddressCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order_grouping_address:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Order Grouping Address Cron';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // return 0;
        DB::transaction(function()
        {
            $orderSchedules = OrderSchedule::select('pickup_address','pickup_postal_code','pickup_city','pickup_latitude','pickup_longitude','pickup_location_id','pickup_date','pickup_time_id','drop_address','drop_postal_code','drop_city','drop_latitude','drop_longitude','drop_location_id')->selectRaw("SUM(quantity) as pickup_quantity")->selectRaw("Count(order_schedule_id) as order_count")->where('status',0)->groupBy('pickup_address','pickup_date','pickup_time_id')->get();
            // $orderSchedules = OrderSchedule::select('pickup_address','pickup_postal_code','pickup_city','pickup_latitude','pickup_longitude','pickup_location_id','pickup_date','pickup_time_id','drop_address','drop_postal_code','drop_city','drop_latitude','drop_longitude','drop_location_id')->selectRaw("SUM(quantity) as pickup_quantity")->selectRaw("Count(order_schedule_id) as order_count")->where('status',0)->groupBy('pickup_address','pickup_date','pickup_time_id','drop_address')->get();
            \Log::info("ordergroupaddress".$orderSchedules);
            if(count($orderSchedules) > 0)
            {
                foreach($orderSchedules as $orderSchedule)
                {                    
                    $orderGroup = OrderGroupingAddress::createOrderGroupingAddress($orderSchedule);
                }
            }
            else
            {
                dd("Insert Error :");
            }
            
        });
    }
}
