
<?php $__env->startSection('styles'); ?>
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1><?php echo e(__('Room Category')); ?></h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#"><?php echo e(__('Home')); ?></a></li>
          <li class="breadcrumb-item active"><?php echo e(__('Room Category')); ?></li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title"><?php echo e(__('Manage Room Category')); ?></h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> <?php echo e(__('Add New Room Category')); ?>

                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="room_category_table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Room Category Name')); ?></th>
                                <th><?php echo e(__('Room Category Code')); ?></th> 
                                <th><?php echo e(__('Description')); ?></th> 
                                <th><?php echo e(__('Status')); ?></th> 
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<!-- DataTables  & Plugins -->
<script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#room_category_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "<?php echo e(route('room-category.index')); ?>",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'room_category_name', name: 'room_category_name'},
            {data: 'room_category_code', name: 'room_category_code'},
            {data: 'room_category_desc', name: 'room_category_desc'},           
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deleteroomcategory').on('click',function(){
              var x = confirm("Do you want to delete the Room Category?");
              if(x == true) { 
              var roomcategory = $(this).data('room-category'); 
                  $.ajax({
                        url: "<?php echo e(route('delete-room-category')); ?>",
                        data: { "id": roomcategory },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                toastr.success(data.message, 'Success');
                                $('#room_category_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "<?php echo e(route('room-category.ajax-add')); ?>",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $( '#modal_lg_title' ).html( 'Add Room Category' );
            $( '#modal_lg_footer' ).html('');
        }
    });
}
function addRoomCategory()
{
    var room_category_name = $('#room_category_add_form #room_category_name').val();
    var room_category_name_ar = $('#room_category_add_form #room_category_name_ar').val();
    var room_category_code = $('#room_category_add_form #room_category_code').val();
    var room_category_desc = $('#room_category_add_form #room_category_desc').val();
    var room_category_desc_ar = $('#room_category_add_form #room_category_desc_ar').val();
    var status = $('#room_category_add_form #status').val();
    $.ajax({
        url: "<?php echo e(route('room-category.addRoomCategory')); ?>",
        data: { "room_category_name": room_category_name, "room_category_name_ar": room_category_name_ar,"room_category_code": room_category_code,"room_category_desc": room_category_desc, "room_category_desc_ar": room_category_desc_ar, "status": status},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addRoomCategoryBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addRoomCategoryBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#room_category_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#room_category_table').DataTable().ajax.reload();
                $("#modal_lg").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
function ajaxEdit(room_category_id){
    $.ajax({
        url: "<?php echo e(route('room-category.ajax-edit')); ?>",
        data: {"room_category_id": room_category_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $( '#modal_lg_title' ).html( 'Edit Room Category' );
            $( '#modal_lg_footer' ).html('');
        }
    });
}
function editRoomCategory()
{
    var room_category_name = $('#room_category_edit_form #room_category_name').val();
    var room_category_name_ar = $('#room_category_edit_form #room_category_name_ar').val();
    var room_category_code = $('#room_category_edit_form #room_category_code').val();
    var room_category_desc = $('#room_category_edit_form #room_category_desc').val();
    var room_category_desc_ar = $('#room_category_edit_form #room_category_desc_ar').val();
    var status = $('#room_category_edit_form #status').val();
    var room_category_id = $('#room_category_edit_form #room_category_id').val(); 
    $.ajax({
        url: "<?php echo e(route('room-category.editRoomCategory')); ?>",
        data: { "room_category_name": room_category_name, "room_category_name_ar": room_category_name_ar,"room_category_code": room_category_code,"room_category_desc": room_category_desc, "room_category_desc_ar": room_category_desc_ar, "status": status, "room_category_id": room_category_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editRoomCategoryBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editRoomCategoryBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#room_category_table').DataTable().ajax.reload();
                $("#modal_lg").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout-admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\extranet\resources\views/pages/admin/room-category/list.blade.php ENDPATH**/ ?>