@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Supplement') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Supplement') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Supplement') }}</h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Supplement') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="supplement_table">
                        <thead>
                            <tr>
                                <th>{{ __('Supplement Name') }}</th>
                                <th>{{ __('Supplement Code') }}</th>
                                <th>{{ __('Supplement Type') }}</th>
                                <th>{{ __('Status') }}</th> 
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#supplement_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('supplement.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'supplement_name', name: 'supplement_name'},
            {data: 'supplement_code', name: 'supplement_code'},
            {data: 'supplement_type', name: 'supplement_type'},           
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletesupplement').on('click',function(){
              var x = confirm("Do you want to delete the Supplement?");
              if(x == true) { 
              var supplementid = $(this).data('supplement'); 
                  $.ajax({
                        url: "{{ route('delete-supplement') }}",
                        data: { "id": supplementid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                //window.location.reload();
                                toastr.success(data.message, 'Success');
                                $('#supplement_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "{{ route('supplement.ajax-add') }}",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Add Supplement' );
            $('#modal_footer' ).html('');
        }
    });
}
function addSupplement()
{
    var supplement_name = $('#supplement_add_form #supplement_name').val();
    var supplement_name_ar = $('#supplement_add_form #supplement_name_ar').val();
    var supplement_code = $('#supplement_add_form #supplement_code').val();
    var supplement_type = $('#supplement_add_form #supplement_type').val();
    var status = $('#supplement_add_form #status').val();
    $.ajax({
        url: "{{ route('supplement.addSupplement') }}",
        data: { "status": status,"supplement_name": supplement_name, "supplement_name_ar": supplement_name_ar,"supplement_code": supplement_code,"supplement_type": supplement_type},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addSupplementBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addSupplementBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#supplement_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#supplement_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
function ajaxEdit(supplement_id){
    $.ajax({
        url: "{{ route('supplement.ajax-edit') }}",
        data: {"supplement_id": supplement_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Edit Supplement' );
            $('#modal_footer' ).html('');
        }
    });
}
function editSupplement()
{
    var supplement_name = $('#supplement_edit_form #supplement_name').val();
    var supplement_name_ar = $('#supplement_edit_form #supplement_name_ar').val();
    var supplement_code = $('#supplement_edit_form #supplement_code').val();
    var supplement_type = $('#supplement_edit_form #supplement_type').val();
    var status = $('#supplement_edit_form #status').val();
    var supplement_id = $('#supplement_edit_form #supplement_id').val(); 
    $.ajax({
        url: "{{ route('supplement.editSupplement') }}",
        data: { "status": status, "supplement_name": supplement_name, "supplement_name_ar": supplement_name_ar, "supplement_code": supplement_code,"supplement_type": supplement_type, "supplement_id": supplement_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editSupplementBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editSupplementBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#supplement_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
@endsection