@extends('layouts.layout-admin')
@section('styles')
<style>
.control-label{
    text-align: right;
}
</style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>{{ __('Edit Setting') }}</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
            <li class="breadcrumb-item active">{{ __('Edit Setting') }}</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
                  <div class="card-header">
                    <h3 class="card-title">{{ __('Edit Setting') }}</h3>                  
                    <span class="tools" style="float:right">
                      <a href="{{ route('setting.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                    </span>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body"> 
                       
                    <form class="form-horizontal" id="setting_edit_form" autocomplete="off" role="form" enctype="multipart/form-data" method="POST" action="{{ route('setting.update', $settingInfo->setting_id ) }}">
                        @csrf
                        {{method_field('PUT')}}
                        <div class="row">
			                <div class="col-lg-12">
                                <div class="form-group row @error('setting_name') has-error @enderror">
                                    <label for="setting_name" class="control-label col-sm-4"> {{ __('Setting Name') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="setting_name" id="setting_name" value="{{ $settingInfo->setting_name }}" placeholder="Setting Name" disabled >
                                        @if($errors->has('setting_name'))
                                        <p class="text-danger">{{ $errors->first('setting_name') }}</p>
                                    @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group row @error('display_name') has-error @enderror">
                                    <label for="display_name" class="control-label col-sm-4"> {{ __('Display Name') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="display_name" id="display_name" value="{{ $settingInfo->display_name }}" placeholder="Display Name" required maxlength="30">
                                        @if($errors->has('display_name'))
                                            <p class="text-danger">{{ $errors->first('display_name') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group row @error('setting_value') has-error @enderror">
                                    <label for="setting_value" class="control-label col-sm-4"> {{ __('Setting Value') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="setting_value" id="setting_value" value="{{ $settingInfo->setting_value }}" placeholder="Setting Value" required maxlength="30">
                                        @if($errors->has('setting_value'))
                                            <p class="text-danger">{{ $errors->first('setting_value') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            {{-- <div class="col-lg-12">
                                <div class="form-group row @error('display_value') has-error @enderror">
                                    <label for="display_value" class="control-label col-sm-4"> {{ __('Display Value') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="display_value" id="display_value" value="{{ $settingInfo->display_value }}" placeholder="Display Value" required maxlength="30">
                                        @if($errors->has('display_value'))
                                            <p class="text-danger">{{ $errors->first('display_value') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div> --}}
                        </div>
                    </div>
                        <div class="form-group row" style="text-align: center;">
                            <div class="col-sm-12">
                                <button type="submit" id="settingEditBtn" class="btn btn-primary">{{ __('Update Setting') }}</button>
                                <a href="{{ route('setting.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </form>
                  </div>
              </div>
          </div>
        </div>
      </div>
  </section>

<!-- page end-->
@endsection
@section('scripts')
<script>
    function getPriceTypeValue(){
    var price_types=document.getElementById("driver_price_type").value;
    if(price_types==1){
        document.getElementById("percent_div").style.display="none";
        document.getElementById("amount_div").style.display="block";

    }
    else if(price_types==2){
        document.getElementById("amount_div").style.display="none";
        document.getElementById("percent_div").style.display="block";
    }
    else{
        document.getElementById("amount_div").style.display="block";
        document.getElementById("percent_div").style.display="block";
    }
}
    </script>
@endsection