@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Location') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Location') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Locations') }}</h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Location') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="location_table">
                        <thead>
                            <tr>
                                <th>{{ __('Facility Name') }}</th>
                                <th>{{ __('Facility Code') }}</th> 
                                <th>{{ __('Setion Type') }}</th> 
                                <th>{{ __('Status') }}</th> 
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#location_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('location.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'country_name', name: 'country_name'},
            {data: 'city_name', name: 'city_name'}, 
            {data: 'zone_code', name: 'zone_code'},           
            {data: 'zone_name', name: 'zone_name'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletelocation').on('click',function(){
              var x = confirm("Do you want to delete the Location?");
              if(x == true) { 
              var imagenameid = $(this).data('location'); 
                  $.ajax({
                        url: "{{ route('delete-location') }}",
                        data: { "id": imagenameid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                toastr.success(data.message, 'Success');
                                $('#location_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "{{ route('location.ajax-add') }}",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Add Location' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function addLocation()
{
    var country_name = $('#location_add_form #country_name').val();
    var country_name_ar = $('#location_add_form #country_name_ar').val();
    var city_name = $('#location_add_form #city_name').val();
    var city_name_ar = $('#location_add_form #city_name_ar').val();
    var zone_code = $('#location_add_form #zone_code').val();
    var zone_code_ar = $('#location_add_form #zone_code_ar').val();
    var zone_name = $('#location_add_form #zone_name').val();
    var zone_name_ar = $('#location_add_form #zone_name_ar').val();
    $.ajax({
        url: "{{ route('location.addLocation') }}",
        data: { "country_name": country_name, "country_name_ar": country_name_ar, "city_name": city_name, "city_name_ar": city_name_ar, "zone_code": zone_code, "zone_code_ar": zone_code_ar, "zone_name": zone_name, "zone_name_ar": zone_name_ar},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addLocationBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addLocationBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#location_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#location_table').DataTable().ajax.reload();
                $("#modal_lg").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
function ajaxEdit(location_id){
    $.ajax({
        url: "{{ route('location.ajax-edit') }}",
        data: {"location_id": location_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Edit Location' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function editLocation()
{
    var country_name = $('#location_edit_form #country_name').val();
    var country_name_ar = $('#location_edit_form #country_name_ar').val();
    var city_name = $('#location_edit_form #city_name').val();
    var city_name_ar = $('#location_edit_form #city_name_ar').val();
    var zone_code = $('#location_edit_form #zone_code').val();
    var zone_code_ar = $('#location_edit_form #zone_code_ar').val();
    var zone_name = $('#location_edit_form #zone_name').val();
    var zone_name_ar = $('#location_edit_form #zone_name_ar').val();
    var location_id = $('#location_edit_form #location_id').val(); 
    $.ajax({
        url: "{{ route('location.editLocation') }}",
        data: { "country_name": country_name, "country_name_ar": country_name_ar, "city_name": city_name, "city_name_ar": city_name_ar, "zone_code": zone_code, "zone_code_ar": zone_code_ar, "zone_name": zone_name, "zone_name_ar": zone_name_ar, "location_id": location_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editLocationBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editLocationBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#location_table').DataTable().ajax.reload();
                $("#modal_lg").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
@endsection