@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Hotel Facility') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Hotel Facility') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Hotel Facility') }}</h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Hotel Facility') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="hotel_facility_table">
                        <thead>
                            <tr>
                                <th>{{ __('Facility Name') }}</th>
                                <th>{{ __('Facility Code') }}</th> 
                                <th>{{ __('Setion Type') }}</th> 
                                <th>{{ __('Status') }}</th> 
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#hotel_facility_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('hotel-facility.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'hotel_facility_name', name: 'hotel_facility_name'},
            {data: 'hotel_facility_code', name: 'hotel_facility_code'}, 
            {data: 'hotel_section_type', name: 'hotel_section_type'},           
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletehotelfacility').on('click',function(){
              var x = confirm("Do you want to delete the Hotel Facility?");
              if(x == true) { 
              var imagenameid = $(this).data('hotel-facility'); 
                  $.ajax({
                        url: "{{ route('delete-hotel-facility') }}",
                        data: { "id": imagenameid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                toastr.success(data.message, 'Success');
                                $('#hotel_facility_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "{{ route('hotel-facility.ajax-add') }}",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Add Hotel Facility' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function addHotelFacility()
{
    var hotel_facility_name = $('#hotel_facility_add_form #hotel_facility_name').val();
    var hotel_facility_name_ar = $('#hotel_facility_add_form #hotel_facility_name_ar').val();
    var hotel_facility_code = $('#hotel_facility_add_form #hotel_facility_code').val();
    var hotel_section_type = $('#hotel_facility_add_form #hotel_section_type').val();
    var hotel_facility_desc = $('#hotel_facility_add_form #hotel_facility_desc').val();
    var hotel_facility_desc_ar = $('#hotel_facility_add_form #hotel_facility_desc_ar').val();
    var status = $('#hotel_facility_add_form #status').val();
    $.ajax({
        url: "{{ route('hotel-facility.addHotelFacility') }}",
        data: { "hotel_facility_name": hotel_facility_name, "hotel_facility_name_ar": hotel_facility_name_ar, "hotel_facility_code": hotel_facility_code, "hotel_section_type": hotel_section_type, "hotel_facility_desc": hotel_facility_desc, "hotel_facility_desc_ar": hotel_facility_desc_ar, "status": status},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addHotelFacilityBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addHotelFacilityBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#hotel_facility_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#hotel_facility_table').DataTable().ajax.reload();
                $("#modal_lg").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
function ajaxEdit(hotel_facility_id){
    $.ajax({
        url: "{{ route('hotel-facility.ajax-edit') }}",
        data: {"hotel_facility_id": hotel_facility_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Edit Hotel Facility' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function editHotelFacility()
{
    var hotel_facility_name = $('#hotel_facility_edit_form #hotel_facility_name').val();
    var hotel_facility_name_ar = $('#hotel_facility_edit_form #hotel_facility_name_ar').val();
    var hotel_facility_code = $('#hotel_facility_edit_form #hotel_facility_code').val();
    var hotel_section_type = $('#hotel_facility_edit_form #hotel_section_type').val();
    var hotel_facility_desc = $('#hotel_facility_edit_form #hotel_facility_desc').val();
    var hotel_facility_desc_ar = $('#hotel_facility_edit_form #hotel_facility_desc_ar').val();
    var status = $('#hotel_facility_edit_form #status').val();
    var hotel_facility_id = $('#hotel_facility_edit_form #hotel_facility_id').val(); 
    $.ajax({
        url: "{{ route('hotel-facility.editHotelFacility') }}",
        data: { "hotel_facility_name": hotel_facility_name, "hotel_facility_name_ar": hotel_facility_name_ar, "hotel_facility_code": hotel_facility_code, "hotel_section_type": hotel_section_type, "hotel_facility_desc": hotel_facility_desc, "hotel_facility_desc_ar": hotel_facility_desc_ar, "status": status, "hotel_facility_id": hotel_facility_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editHotelFacilityBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editHotelFacilityBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#hotel_facility_table').DataTable().ajax.reload();
                $("#modal_lg").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
@endsection