<form class="form-horizontal" id="contact_type_edit_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group row @error('contact_type_name') has-error @enderror">
                <label for="contact_type_name" class="control-label col-sm-4"> {{ __('Contact Type Name') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="contact_type_name" id="contact_type_name" value="{{ $contactTypeInfo->contact_type_name }}" placeholder="Contact Type Name" required maxlength="30">
                    @if($errors->has('contact_type_name'))
                        <p class="text-danger">{{ $errors->first('contact_type_name') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('contact_type_name_ar') has-error @enderror">
                <label for="contact_type_name_ar" class="control-label col-sm-4"> {{ __('Contact Type Name (AR)') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="contact_type_name_ar" id="contact_type_name_ar" value="{{ $contactTypeInfo->contact_type_name_ar }}" placeholder="Contact Type Name" required maxlength="30">
                    @if($errors->has('contact_type_name_ar'))
                        <p class="text-danger">{{ $errors->first('contact_type_name_ar') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('contact_type_code') has-error @enderror">
                <label for="contact_type_code" class="control-label col-sm-4"> {{ __('Contact Type Code') }}</label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="contact_type_code" id="contact_type_code" value="{{ $contactTypeInfo->contact_type_code }}" placeholder="Contact Type Code" maxlength="30">
                    @if($errors->has('contact_type_code'))
                        <p class="text-danger">{{ $errors->first('contact_type_code') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('status') has-error @enderror">
                <label for="status" class="control-label col-sm-4"> {{ __('Status') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    {!! Form::select('status', $status, $contactTypeInfo->status, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                    @if($errors->has('status'))
                        <p class="text-danger">{{ $errors->first('status') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
        <input type="hidden" name="contact_type_id" id="contact_type_id" value="{{ $contactTypeInfo->id }}" />
            <button type="button" id="contactTypeEditBtn" class="btn btn-primary" onclick="return editContactType();">{{ __('Update Contact Type') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
