<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    use HasFactory;

    public function scopeIsNotDeleted($query) 
    {
        return $query->where('is_deleted','!=',1);
    }

    public function childs() {
        return $this->hasMany('App\Models\Menu','parent_menu_id','menu_id') ;
    }

    public function permission() {
        return $this->hasOne('Spatie\Permission\Models\Permission','id','permission_id');
    }

}
