<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Location extends Model
{
    use HasFactory;
    
    protected $guarded = []; //It is the exact opposite of $fillable sort of like telling the database to accept everything, except the fields you specify inside the $guarded array.

    public function scopeIsNotDeleted($query) 
    {
        return $query->where('is_deleted','!=',1);
    }
    
}
