<?php

namespace App\Http\Requests\Vehicle;

use Illuminate\Foundation\Http\FormRequest;

class UpdateVehicleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('edit vehicle');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "driver_id" => "required",
            "reg_number" => "required|unique:vehicles,reg_number," . $this->vehicle . ",vehicle_id",
            "model_number" => "required",
            
            "insurance_company" => "required",
            "insurance_number" => "required|unique:vehicles,insurance_number," . $this->vehicle.",vehicle_id",
            
            "vehicle_type" => "required",
            "status" => "required",
        ];
    }
}
