<?php

namespace App\Http\Requests\Vehicle;

use Illuminate\Foundation\Http\FormRequest;

class StoreVehicleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create vehicle');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "driver_id" => "required",
            "reg_number" => "required|unique:vehicles,reg_number",
            "model_number" => "required",
           
            "insurance_company" => "required",
            "insurance_number" => "required|unique:vehicles,insurance_number",
            
            "vehicle_type" => "required",
            "status" => "required",
        ];
    }
}
