<?php

namespace App\Http\Requests\Topup;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTopupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('edit topup');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'merchant_id'=>'required',
            'no_of_credits'=>'required',
            'receipt'=>'required',
        ];
    }
}
