<?php

namespace App\Http\Requests\SalesPerson;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class UpdateSalesPersonRequest extends FormRequest
{
    
       /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        
        return $this->user()->can('edit sales person');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "first_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "last_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "email" => 'required|unique:users,email,'.$this->user_id,
            "country_code_id" => "required",
            "phone" => 'required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone,'.$this->user_id,
            // "phone" => 'required|regex:/^[0-9]+$/|max:30|unique:users,phone,'.$this->user_id,
        ];
    
        if (auth()->user()->role === 'SUPER_ADMIN') {
            $rules['merchant_id'] = 'required';
        }
    
        return $rules;
       
    }
}
