<?php

namespace App\Http\Requests\PackageSetting;

use Illuminate\Foundation\Http\FormRequest;

class StorePackageSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create package setting');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "package_name"=>"required",
            "min_size_in_cm" => "required|max:10",
            "max_size_in_cm" => "required|max:10",
            "door_step_delivery_cost" => "required|max:10",
            "hub_rental_cost" => "required|max:10",
            "category" => "required",
            // "vehicle_type" => "required",
            // "merchant_cost_in_rm" => "required|max:10",
            "driver_price_type" => "required|max:10",
            "driver_price_in_rm" => "required_if:driver_price_type,==,1,|max:10",
            "driver_price_in_perc" => "required_if:driver_price_type,==,2,|max:10",
            // xt
            "additional_pkg_cost" => "required_if:category,==,1,|max:10",
            "merchant_cost_in_rm" => "required_if:category,==,1,|max:10",
            "min_cost_dist" => "required_if:category,==,2,|max:10",
            "min_cost" => "required_if:category,==,2,|max:10",
            "additional_dist_cost" => "required_if:category,==,2,|max:10",

        ];
    }
}
