<?php

namespace App\Http\Requests\Merchant;

use Illuminate\Foundation\Http\FormRequest;

class StoreMerchantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create merchant');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "first_name" => "required",
            "last_name" => "required",
            "email" => "required|email|unique:users,email",
            "address_1" => "required",                    
            "postal_code_1" => "required",           
            "city_1" => "required",           
            "state_1" => "required",           
            "country_1" => "required",   
            "country_code_id"=>"required",
            // "address_2" => "required",                    
            // "postal_code_2" => "required",           
            // "city_2" => "required",           
            // "state_2" => "required",           
            // "country_2" => "required",        
            // "phone" => "required|unique:users,phone",
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone",
            "logo" => "required",
            "ssm_number" => "required",
            "company_name" => "required",
            "company_email" => "required",
            "company_phone" => "required|regex:/^[0-9]+$/|min:8|max:14",
            "company_country_code_id"=>"required",
            "product_category" => "required",
            "product_images" => "required",
            "password" => "required",
            "status" => "required",
        ];
    }
}
