<?php

namespace App\Http\Requests\Driver;

use Illuminate\Foundation\Http\FormRequest;

class UpdateDriverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('edit driver');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "first_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "last_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "email" => "required|unique:users,email," . $this->user_id . "",
            "country_code_id" => "required",
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone,". $this->user_id . "",
            // "phone" =>  "required|regex:/^[0-9]+$/|max:30|unique:users,phone,". $this->user_id . "",
            "address" => "required|max:100",                      
            "postal_code" =>  "required|regex:/^[0-9]+$/|max:5",
            "city" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "state" =>"required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "country" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "ic_number" => "required|regex:/(^[A-Za-z0-9]+$)+/|unique:drivers,ic_number,".$this->driver.",driver_id",           
            // "ic_image" => "required",
            "license_number" => "required|regex:/(^[A-Za-z0-9]+$)+/|unique:drivers,license_number,".$this->driver.",driver_id",
            "status" => "required",
        ];
    }
}
