<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\RoomCategory;
use DataTables;
use Validator;

class RoomCategoryController extends Controller
{
    public function __construct()
    {
        $this->roomCategoryStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = RoomCategory::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("room_category_name", function ($data) {
                    if (empty($data->room_category_name)) {
                        return "N/A";
                    }
                    return $data->room_category_name;
                })
                ->addColumn("room_category_code", function ($data) {
                    if (empty($data->room_category_code)) {
                        return "N/A";
                    }
                    return $data->room_category_code;
                })
                ->addColumn("room_category_desc", function ($data) {
                    if (empty($data->room_category_desc)) {
                        return "N/A";
                    }
                    return $data->room_category_desc;
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-info">Action</button>
                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deleteroomcategory" href="javascript:;" data-room-category="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Room Category";
        return view("pages.admin.room-category.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $roomCategory = RoomCategory::find($request->id);
        $roomCategory->is_deleted = 1;
        $roomCategory->deleted_at = date('Y-m-d H:i:s');
        $roomCategory->save();
        //$roomCategory->delete();
        return response()->json(['status' => 'success', 'message' => 'Room Category information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->roomCategoryStatus;
        return view('pages.admin.room-category.ajaxAdd',$data);
    }
    public function addRoomCategory(Request $request)
    {
        $messages = array(
                    'room_category_name.required' => 'Hotel Category Name is Required',
                    'room_category_name_ar.required' => 'Hotel Category Name(AR) is Required',
                );
        $validator = Validator::make($request->all(), ['room_category_name' => 'required','room_category_name_ar' => 'required'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $roomCategory = RoomCategory::create([            
                "room_category_name" => trim($request->room_category_name),
                "room_category_name_ar" => trim($request->room_category_name_ar),
                "room_category_code" => trim($request->room_category_code),
                "room_category_desc" => trim($request->room_category_desc),
                "room_category_desc_ar" => trim($request->room_category_desc_ar),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Room Category added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $roomCategoryInfo = RoomCategory::find($request->room_category_id);
        $data["roomCategoryInfo"] = $roomCategoryInfo;
        $data["status"] = $this->roomCategoryStatus;
        return view('pages.admin.room-category.ajaxEdit',$data);
    }
    public function editRoomCategory(Request $request)
    {
        $messages = array(
                    'room_category_name.required' => 'Hotel Category Name is Required',
                    'room_category_name_ar.required' => 'Hotel Category Name(AR) is Required',
                );
        $validator = Validator::make($request->all(), ['room_category_name' => 'required','room_category_name_ar' => 'required'], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $roomCategory = RoomCategory::find($request->room_category_id);
            $roomCategory->room_category_name = $request->room_category_name;
            $roomCategory->room_category_name_ar = $request->room_category_name_ar;
            $roomCategory->room_category_code = $request->room_category_code;
            $roomCategory->room_category_desc = $request->room_category_desc;
            $roomCategory->room_category_desc_ar = $request->room_category_desc_ar;
            $roomCategory->status = $request->status;
            $roomCategory->save();

            return response()->json(['status' => 'success', 'message' => 'Room Category updated successfully.', 'error' => ''], 200);
        }
    }
}
