<?php

namespace App\Http\Controllers\API\V1;

// use App\Http\Controllers\Controller;
use App\Http\Controllers\API\V1\BaseController as BaseController;

use Illuminate\Http\Request;
use App\Models\PostalCode;
use App\Models\PreferredLocation;
use App\Models\UserPreferredLocation;
use DB;
use Auth;
use Illuminate\Database\QueryException;
use Validator;
use Illuminate\Support\Facades\Mail;
use App\Mail\Welcome;
use App\Models\User;

class PreferredAreaController extends BaseController
{
    public function listNearByArea(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "latitude" => "required",
            "longitude" => "required",
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors(),422);       
        }  
    
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $nearByAreas = PostalCode::select(
            DB::raw(
                "preferred_location_id, ( 6367 * acos( cos( radians(" .
                    $latitude .
                    ") ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians(" .
                    $longitude .
                    ") ) + sin( radians(" .
                    $latitude .
                    ") ) * sin( radians( latitude ) ) ) ) AS distance"
            )
        )
        ->having('distance', '<', 10)//10km        
        ->orderBy("distance")
        ->get();
        $preferred_location_id = array();
        foreach($nearByAreas as $nearByArea)
        {
            $preferred_location_id[] =$nearByArea->preferred_location_id;
        }
        $arr_preferred_ids =  array_unique($preferred_location_id);
        $preferred_locations = PreferredLocation::whereIn('preferred_location_id',$arr_preferred_ids)->get()->pluck('preferred_location_place','preferred_location_id');
        
        $success['preferred_locations'] =  $preferred_locations;
        $success['user_id'] =  Auth::user()->id;
        $success['approve_status'] = 'Pending'; 
        return $this->sendResponse($success, 'Preferred Area List.',200);

    }
    public function setNearByPreferredArea(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "preferred_location_ids" => "required"
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors(),422);       
        }
        //$preferred_location_ids = explode(',',$request->preferred_location_ids);
        $preferred_location_ids = $request->preferred_location_ids;
        try
        {
            foreach($preferred_location_ids as $preferred_location_id)
            {
                $update = UserPreferredLocation::updateOrCreate(
                    ['user_id' => auth()->user()->id, 'preferred_location_id' => $preferred_location_id],
                    ['user_id' => auth()->user()->id]
                );
            }   

            $updateUserRegisterPage = User::updateRegisterPage(auth()->user()->id,4);//update success register page
            $user_name = auth()->user()->user_name;
            // Mail::to(auth()->user()->email)->send(new Welcome($email));
            //Mail::to('jyothibv@yopmail.com')->send(new Welcome($user_name));

            $success['user_id'] =  Auth::user()->id;
            $success['approve_status'] = 'Pending'; 
            return $this->sendResponse($success, 'Preferred Location Updated Successfully.',200);
        }
        catch(QueryException $ex)
        {
            return $this->sendError('Update Query Error.', "Update Error");       
        }
    }
}
