<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\API\V1\BaseController as BaseController;
use Illuminate\Http\Request;
use App\Models\Merchant;
use App\Models\ProductCategory;
use Auth;

class MerchantController extends BaseController
{
    public function merchantList(Request $request)
    {
        $merchantList = Merchant::all();
        $dataMerchantList = [];
        if(count($merchantList)>0)
        {
            foreach($merchantList as $merchant)
            {
                $productImg = [];
                if(!empty($merchant->product_images))
                {
                    $arrProdImg = explode("~",$merchant->product_images);
                    if(count($arrProdImg)>0)
                    {
                        foreach($arrProdImg as $prodImg)
                        {
                            $productImg[] = !empty($prodImg)
                            ? URL("uploads/product_images/" . $prodImg)
                            : URL("images/noimage.png");
                        }
                    }
                }else{
                    $productImg[] = URL("images/noimage.png");
                }
                $prodCatName=[];
                if(!empty($merchant->product_category))
                {
                    $arrProdCat = explode(",",$merchant->product_category);
                    if(count($arrProdCat)>0)
                    {
                        foreach($arrProdCat as $prodCat)
                        {
                            $prodCategory = ProductCategory::find($prodCat);
                            $prodCatName[$prodCat] = $prodCategory->name;
                        }
                    }
                }
                else
                {
                    $prodCatName[0] = 'all';
                }   
                
                $dataMerchantList[] = array(
                    "merchant_id" => $merchant->merchant_id,
                    "user_name" => $merchant->user->user_name,
                    "email" => $merchant->user->email,
                    "address_line_11" => $merchant->commAddressOne->address_line_1,
                    "address_line_12" => $merchant->commAddressOne->address_line_2,
                    "postal_code_1" => $merchant->commAddressOne->postal_code,
                    "city_1" => $merchant->commAddressOne->city,
                    "state_1" => $merchant->commAddressOne->state,
                    "country_1" => $merchant->commAddressOne->country,
                    "address_line_21" => $merchant->commAddressTwo->address_line_1,
                    "address_line_22" => $merchant->commAddressTwo->address_line_2,
                    "postal_code_2" => $merchant->commAddressTwo->postal_code,
                    "city_2" => $merchant->commAddressTwo->city,
                    "state_2" => $merchant->commAddressTwo->state,
                    "country_2" => $merchant->commAddressTwo->country,
                    "phone" => $merchant->user->phone,
                    "ssm_number" => $merchant->ssm_number,
                    "company_name" => $merchant->company_name,
                    "company_email" => $merchant->company_email,
                    "company_phone" => $merchant->company_phone,
                    "product_category" => $prodCatName,
                    "product_images" =>  $productImg,
                    "last_login_at" => $merchant->user->last_login_at,
                    "approved_status" => $merchant->user->is_approved
                );
            }
            $success['merchant_list'] = $dataMerchantList;
            $success['data_count'] = count($dataMerchantList);
            return $this->sendResponse($success, 'Merchant List.');
        }
        else
        { 
            return $this->sendError('No merchants in the list.', ['error'=>'No Merchants in the List']);
        }        
    }
}
