<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\API\V1\BaseController as BaseController;
use App\Models\AddressBook;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\Driver;
use App\Models\FirebaseUid;
use App\Models\User;
use App\Models\UserDevice;
use Exception;
use Illuminate\Database\QueryException;
use Validator;
use Carbon\Carbon;

class DriverRegisterController extends BaseController
{
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "first_name" => "required",
            "last_name" => "required",
            "email" => "required|email|unique:users,email",
            "country_code_id" => "required",
            "phone" => "required|min:8|max:14|unique:users,phone",
            "address" => "required",                
            "postal_code" => "required",           
            "city" => "required",           
            "state" => "required",           
            "country" => "required",   
            "ic_number" => "required|unique:drivers,ic_number",           
            "ic_image" => "required",        
            "license_number" => "required|unique:drivers,license_number",
            "password" => "required"
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors(),422);       
        }


        $ic_image = $request->ic_image; // your base64 encoded
        if ($ic_image) {
            $image_data = base64_decode(
                preg_replace("#^data:image/\w+;base64,#i", "", $ic_image)
            );
            $f = finfo_open();
            $mime_type = finfo_buffer($f, $image_data, FILEINFO_MIME_TYPE);
            $ext = explode("/", $mime_type);
            $imageName = time() . "_ic_image." . $ext[1];
            \File::put(
                public_path() . "/uploads/drivers/ic_images/" . $imageName,
                $image_data
            );
            $filename = $imageName;
        }       
        
        try
        {
            $register = 1;
            $user_id = User::createUser($request,'DRIVER',$register);
            // $user_id = User::updateOrCreateUser($request,'DRIVER',$register);
            if($user_id)
            {                
                try
                {
                    $device = UserDevice::registerDevices($request,$user_id);
                    $driver = Driver::create([
                        "user_id" => $user_id,            
                        "first_name" => trim($request->first_name),
                        "last_name" => trim($request->last_name),
                        "phone" => trim($request->phone),
                        "ic_number" => trim($request->ic_number),
                        "ic_image" => $filename,
                        "license_number" => trim($request->license_number),
                        "carplate_number" => trim($request->carplate_number),
                        "car_model" => trim($request->car_model),
                        "insurance_expiry_date" => date('Y-m-d', strtotime($request->insurance_expiry_date)),
                        "vehicle_type" => trim($request->vehicle_type),
                        "insurance_company" => trim($request->insurance_company),
                        "created_by" => $user_id,
                    ]);

                    // return $driver->id;
                    $userData['address_type'] = 1;//Address
                    $userData['user_id'] = $user_id;
                    $userData['driver_id'] = $driver->driver_id;  

                    $address1['address'] = ($request->address)?$request->address:''; 
                    $address1['address_line_1'] = ($request->address_line_1)?$request->address_line_1:''; 
                    $address1['address_line_2'] = ($request->address_line_2)?$request->address_line_2:''; 
                    $address1['postal_code'] = ($request->postal_code)?$request->postal_code:''; 
                    $address1['city'] = ($request->city)?$request->city:''; 
                    $address1['district'] = ($request->district)?$request->district:''; 
                    $address1['state'] = ($request->state)?$request->state:''; 
                    $address1['country'] = ($request->country)?$request->country:''; 
                    $address1['latitude'] = ($request->latitude)?$request->latitude:''; 
                    $address1['longitude'] = ($request->longitude)?$request->longitude:''; 

                    $addrId = AddressBook::createAddress($address1,$userData,$register);                 
                    $update = Driver::updateAddressBookId($driver->driver_id,$addrId); 
                    $updateUserRegisterPage = User::updateRegisterPage($user_id,2); //update add vehicle page                       

                    $userInfo = User::find($user_id);
                    $tokenResult = $userInfo->createToken('suhu');
                    $token = $tokenResult->token;                       
                    $token->expires_at = Carbon::now()->addWeeks(1);       // Add a expiration date to the token    
                    $token->save(); // Save the token to the user

                    //$success['token'] = $tokenResult->accessToken;
                    $success['user_id'] =  $user_id;
                    $success['driver_id'] =  $userData['driver_id'];
                    $success['address_id'] =  $addrId;
                    $success['first_name'] = trim($request->first_name);
                    $success['last_name'] = trim($request->last_name);
                    $success['email'] = $userInfo->email;
                    $success['phone'] = $userInfo->phone;
                    $success['address'] = $userInfo->address;
                    $success['approve_status'] = 'Pending';
                    //$success['redirect_to'] = 'register_second_page';
                    //$success['redirect_url'] = URL('api/v1/add-vehicle'); 
                    $res['user_info'] = $success;
                    return $this->sendResponse($res, 'Driver register successfully.',201);
                
                }
                catch(QueryException $ex) 
                {
                    return $this->sendError('Insertion Query error', ['error'=>$ex],400);              
                }
            }
        }
        catch(QueryException $ex) 
        {
            return $this->sendError('User Insertion error', ['error'=>$ex],400);                                
        }
    }

    public function updateRegister(Request $request)
    {
        $verify_uid = FirebaseUid::verifyFirebaseUid($request);
        if($verify_uid)
        {
            $validator = Validator::make($request->all(), [
                "first_name" => "required",
                "last_name" => "required",
                "email" => "required|unique:users,email," . $request->user_id . "",
                "country_code_id" => "required",
                "phone" =>  "required|min:8|max:14|unique:users,phone,". $request->user_id . "",
                "address" => "required",                
                "postal_code" => "required",           
                "city" => "required",           
                "state" => "required",           
                "country" => "required",   
                // "ic_number" => "required",           
                "ic_number" => "required|unique:drivers,ic_number,".$request->driver_id.",driver_id",           
                "ic_image" => "required",        
                // "license_number" => "required",
                "license_number" => "required|unique:drivers,license_number,".$request->driver_id.",driver_id",  
                // "password" => "required",           
            ]);
    
            if($validator->fails()){
                return $this->sendError('Validation Error.', $validator->errors(),422);       
            }           
            
            try
            {
                $user_id = User::updateUser($request,'DRIVER');
                if($user_id)
                {                   
                    try
                    {
                        $driver = Driver::find($request->driver_id);
                        $driver->user_id = $user_id;
                        $driver->first_name = $request->first_name;
                        $driver->last_name = $request->last_name;                       
                        $driver->ic_number = $request->ic_number;
                        $ic_image = $request->ic_image; // your base64 encoded

                        if ($ic_image) {
                            unlink(
                                base_path() .
                                "/public/uploads/drivers/ic_images/" .
                                $driver->ic_image
                            );
                            $image_data = base64_decode(
                                preg_replace("#^data:image/\w+;base64,#i", "", $ic_image)
                            );
                            $f = finfo_open();
                            $mime_type = finfo_buffer($f, $image_data, FILEINFO_MIME_TYPE);
                            $ext = explode("/", $mime_type);
                            $imageName = time() . "_ic_image." . $ext[1];
                            \File::put(
                                public_path() . "/uploads/drivers/ic_images/" . $imageName,
                                $image_data
                            );
                            $filename = $imageName;
                            $driver->ic_image = $filename;
                        }  

                        $driver->license_number = $request->license_number;
                        $driver->status = $request->status;
                        $driver->updated_at = date('Y-m-d H:i:s');
                        $driver->save();    
                        
                        $userData['address_type'] = 1;//Address
                        $userData['user_id'] = $user_id;
                        $userData['driver_id'] = $request->driver_id;
                        
                        $driver = Driver::where('driver_id',$request->driver_id)->first();
                        $address_book_id = $driver->address_book_id;                        
                        
                        $address1['address'] = ($request->address)?$request->address:''; 
                        $address1['address_line_1'] = ($request->address_line_1)?$request->address_line_1:''; 
                        $address1['address_line_2'] = ($request->address_line_2)?$request->address_line_2:''; 
                        $address1['postal_code'] = ($request->postal_code)?$request->postal_code:''; 
                        $address1['city'] = ($request->city)?$request->city:''; 
                        $address1['district'] = ($request->district)?$request->district:''; 
                        $address1['state'] = ($request->state)?$request->state:''; 
                        $address1['country'] = ($request->country)?$request->country:''; 
                        $address1['latitude'] = ($request->latitude)?$request->latitude:''; 
                        $address1['longitude'] = ($request->longitude)?$request->longitude:''; 
                        $addrId = AddressBook::updateAddress($address1,$userData,$address_book_id);
 
                        $update = Driver::updateAddressBookId($driver->driver_id,$addrId);
                        $updateUserRegisterPage = User::updateRegisterPage($user_id,2); //update add vehicle page                       

                        // $update = \DB::table('drivers')
                        // ->where('driver_id', $driver->driver_id)
                        // ->update(['address_book_id' => $addrId, 'updated_at' => date('Y-m-d H:i:s')]);
           
                        // $userInfo = User::find($user_id);
                        // $tokenResult = $userInfo->createToken('suhu');
                        // $token = $tokenResult->token;                       
                        // $token->expires_at = Carbon::now()->addWeeks(1);       // Add a expiration date to the token    
                        // $token->save(); // Save the token to the user

                        $success['token'] = $request->bearerToken();
                        $success['user_id'] =  $user_id;
                        $success['driver_id'] =  $userData['driver_id'];
                        $success['address_id'] =  $addrId;
                        $success['approve_status'] = 'Pending'; 
                        $success['redirect_to'] = 'register_second_page';
                        $success['redirect_url'] = URL('api/v1/add-vehicle'); 

                        return $this->sendResponse($success, 'Driver register successfully.',201);     

                    }
                    catch(QueryException $ex) 
                    {
                        return $this->sendError('Update Query error', ['error'=>$ex],400);                
                    }
                }
            }
            catch(QueryException $ex) 
            {
                return $this->sendError('User Update error', ['error'=>$ex],400);                  
            }
        }
        else
        {
            $failed = [
                'redirect_to' => 'verify_firebase_token_page',
                'redirect_url' => URL('api/v1/verify-firebase-token')
              ];
              return $this->sendError($failed, "Not Verified. New User",400);
        }
    }
}
