<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['prefix' => 'v1', 'namespace' => 'API\V1'], function () {
    Route::post('/driver-register', [App\Http\Controllers\API\V1\DriverRegisterController::class,'register'])->name('api.driver-register');
    Route::post('/driver-login', [App\Http\Controllers\API\V1\DriverLoginController::class,'login'])->name('api.driver-login');
    Route::get('/merchant-list', [App\Http\Controllers\API\V1\MerchantController::class,'merchantList'])->name('api.merchant-list');
    Route::get('/verify-firebase-token',[App\Http\Controllers\API\V1\FirebaseController::class,'verifyToken']);
    Route::get('/master-data',[App\Http\Controllers\API\V1\MasterController::class,'listMasterData'])->name('api.master-data');

    /*************AUTH*************/
    Route::group(['middleware' => 'auth:api'], function () {
        Route::post('/update-driver-register', [App\Http\Controllers\API\V1\DriverRegisterController::class,'updateRegister'])->name('api.update-driver-register');
        Route::post('/add-vehicle', [App\Http\Controllers\API\V1\VehicleController::class,'addVehicle'])->name('api.add-vehicle');
        Route::post('/update-vehicle', [App\Http\Controllers\API\V1\VehicleController::class,'updateVehicle'])->name('api.update-vehicle');
        Route::get('/list-near-by-preferred-area',[App\Http\Controllers\API\V1\PreferredAreaController::class,'listNearByArea'])->name('api.list-near-by-preferred-area');
        Route::post('/set-near-by-preferred-area',[App\Http\Controllers\API\V1\PreferredAreaController::class,'setNearByPreferredArea'])->name('api.set-near-by-preferred-area');
    });
});
