@extends('layouts.layout-admin')
@section('styles')
<!-- Select2 -->
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
.control-label{
    text-align: right;
}
.hide{
    display: none;
}
</style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>{{ __('Edit Order') }}</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
            <li class="breadcrumb-item active">{{ __('Edit Order') }}</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
                  <div class="card-header">
                    <h3 class="card-title">{{ __('Edit Order') }}</h3>                  
                    <span class="tools" style="float:right">
                      <a href="{{ route('merchant.order.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                    </span>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body"> 
                    {!! Form::open(array('url' =>'merchant/order/update', 'method'=>'post', 'class' => 'form-horizontal form-validate', 'enctype'=>'multipart/form-data')) !!}   
                        @csrf
                        {{method_field('PUT')}}                   
                        <div class="row">
                          <div class="col-md-6">
                            <div class="row">
                              <div class="col-md-4">
                                <h4>{{ __('Customer Details') }}</h4>
                              </div>
                            </div>
                            <div class="form-group row">
                              
                              <div class="custom-control custom-radio col-md-3 m-3">
                                <input class="custom-control-input" type="radio" id="new_customer" name="customer_type" value="1" required>
                                <label for="new_customer" class="custom-control-label">{{ __('New Customer') }}</label>
                              </div>
                              <div class="custom-control custom-radio col-md-4 m-3">
                                <input class="custom-control-input" type="radio" id="exist_customer" name="customer_type" value="2">
                                <label for="exist_customer" class="custom-control-label">{{ __('Existing Customer') }}</label>
                              </div>                              
                            </div>
                            <div class="form-group d-none m-3" id="new_customer_form" >                              
                              <div class="form-group row @error('user_name') has-error @enderror">                                
                                <label for="user_name" class="control-label col-sm-4"> {{ __('User Name') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">    
                                    <input type="text" class="form-control" name="user_name" id="user_name" placeholder="User Name">
                                    @if($errors->has('user_name'))
                                        <p class="text-danger">{{ $errors->first('user_name') }}</p>
                                    @endif
                                </div>
                              </div>
                              <div class="form-group row @error('email') has-error @enderror">
                                <label for="email" class="control-label col-sm-4">{{ __('Email') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="email" class="form-control" name="email" id="email" placeholder="Email">
                                    @if($errors->has('email'))
                                        <p class="text-danger">{{ $errors->first('email') }}</p>
                                    @endif
                                </div>
                              </div>
                              <div class="form-group row @error('phone') has-error @enderror">
                                <label for="phone" class="control-label col-sm-4">{{ __('Phone Number') }} <span class="text-danger">*</span></label></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="phone" id="phone" maxlength="13" value="{{Request::old('phone')}}" placeholder="Example : 012 345 6789" />
                                    @if($errors->has('phone'))
                                        <p class="text-danger">{{ $errors->first('phone') }}</p>
                                    @endif
                                </div>
                              </div>
                              <div class="form-group row @error('address_line_1') has-error @enderror">
                                  <label for="address_line_1" class="control-label col-sm-4">{{ __('Address Line 1') }} <span class="text-danger">*</span></label>
                                  <div class="col-sm-8">
                                  <input type="text" class="form-control" name="address_line_1" id="address_line_1" placeholder="Address Line 1"/>
                                  @if($errors->has('address_line_1'))
                                      <p class="text-danger">{{ $errors->first('address_line_1') }}</p>
                                  @endif
                                  </div>
                              </div>
                              <div class="form-group row @error('address_line_2') has-error @enderror">
                                  <label for="address_line_2" class="control-label col-sm-4">{{ __('Address Line 2') }} <span class="text-danger">*</span></label>
                                  <div class="col-sm-8">
                                  <input type="text" class="form-control" name="address_line_2" id="address_line_2" placeholder="Address Line 2" />
                                  @if($errors->has('address_line_2'))
                                      <p class="text-danger">{{ $errors->first('address_line_2') }}</p>
                                  @endif
                                  </div>
                              </div>
                              <div class="form-group row @error('postal_code') has-error @enderror">
                                <label for="postal_code" class="control-label col-sm-4">{{ __('Postal Code') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                <input type="text" class="form-control" name="postal_code" id="postal_code" placeholder="Postal Code"/>
                                @if($errors->has('postal_code'))
                                    <p class="text-danger">{{ $errors->first('postal_code') }}</p>
                                @endif
                                </div>
                              </div>
                              <div class="form-group row @error('city') has-error @enderror">
                                <label for="city" class="control-label col-sm-4">{{ __('City') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                <input type="text" class="form-control" name="city" id="city" placeholder="City"/>
                                @if($errors->has('city'))
                                    <p class="text-danger">{{ $errors->first('city') }}</p>
                                @endif
                                </div>
                              </div>
                              
                              <div class="form-group row @error('state') has-error @enderror">
                                <label for="state" class="control-label col-sm-4">{{ __('State') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                <input type="text" class="form-control" name="state" id="state" placeholder="State"/>
                                @if($errors->has('state'))
                                    <p class="text-danger">{{ $errors->first('state') }}</p>
                                @endif
                                </div>
                              </div>
                              <div class="form-group row @error('country') has-error @enderror">
                                <label for="country" class="control-label col-sm-4">{{ __('Country') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                <input type="text" class="form-control" name="country" id="country" placeholder="Country"/>
                                @if($errors->has('country'))
                                    <p class="text-danger">{{ $errors->first('country') }}</p>
                                @endif
                                </div>
                              </div>
                              
                              <div class="form-group row @error('company_name') has-error @enderror">
                                <label for="company_name" class="control-label col-sm-4">{{ __('Company Name') }} <span class="text-danger">*</span></label></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="company_name" id="company_name"  value="{{Request::old('company_name')}}" placeholder="Company Name" />
                                    @if($errors->has('company_name'))
                                        <p class="text-danger">{{ $errors->first('company_name') }}</p>
                                    @endif
                                </div>
                              </div>
                                                     
                            </div>
                            <div class="form-group d-none m-3" id="exist_customer_form" >
                              <div class="row">
                                <div class="col-md-12">
                                  <div class="form-group" id="customer-box">
                                    <label>{{ __('Search Customer') }}</label>
                                    {{-- {!! Form::select('customer_name', $customer_names, null, ['class' => 'form-control m-bot15 select2bs4','id'=>'customer_name','required' => 'required','data-url'=>route('merchant.order.customer')]) !!}                                   --}}
                                    <select id="customer_id" name="customer_id" data-placeholder="Select Customer" class="form-control select2bs4" required data-url="{{ route('merchant.order.customer') }}">
                                      <option value="0" selected disabled> {{ __('select customer') }} </option>
                                       @foreach($customers as $customer)
                                            <option value="{{$customer->id}}">{{$customer->user_name}} {{ $customer->email }} {{ $customer->address_line_1 }} {{ $customer->address_line_2}} {{ $customer->postal_code }}</option>
                                        @endforeach
                                    </select>
                                    
                                  </div>
                                </div>
                              </div>
                              <div class="row">                             
                                <div class="col-md-12 m-3 d-none" id="customer_details">
                                  
                                </div>
                              </div>
                              
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="row">
                              <div class="col-md-4">
                                <h4>{{ __('Parcel Details') }}</h4>
                              </div>
                            </div>
                            <div class="row">
                              <div class="form-group col-sm-3 @error('height') has-error @enderror">
                                <label for="height" class="control-label ">{{ __('Height') }} <span class="text-danger">*</span></label></label>
                                
                                    <input type="text" class="form-control" name="height" id="height" maxlength="13" value="{{Request::old('height')}}" placeholder="Height" required />
                                    @if($errors->has('height'))
                                        <p class="text-danger">{{ $errors->first('height') }}</p>
                                    @endif
                                
                              </div>
                              <div class="form-group col-sm-3 @error('length') has-error @enderror">
                                <label for="length" class="control-label">{{ __('Length') }} <span class="text-danger">*</span></label></label>
                                
                                    <input type="text" class="form-control" name="length" id="length" maxlength="13" value="{{Request::old('length')}}" placeholder="Length" required />
                                    @if($errors->has('length'))
                                        <p class="text-danger">{{ $errors->first('length') }}</p>
                                    @endif
                                
                              </div>
                              <div class="form-group col-sm-3 @error('width') has-error @enderror">
                                <label for="width" class="control-label">{{ __('Width') }} <span class="text-danger">*</span></label></label>
                                
                                    <input type="text" class="form-control" name="width" id="width" maxlength="13" value="{{Request::old('width')}}" placeholder="Width" required />
                                    @if($errors->has('width'))
                                        <p class="text-danger">{{ $errors->first('width') }}</p>
                                    @endif
                                
                              </div>
                              <div class="form-group col-sm-3 @error('price') has-error @enderror">
                                <label for="price" class="control-label">{{ __('Price') }} <span class="text-danger">*</span></label></label>
                                
                                    <input type="text" class="form-control" name="price" id="price" maxlength="13" value="{{Request::old('price')}}" placeholder="Price" required />
                                    @if($errors->has('price'))
                                        <p class="text-danger">{{ $errors->first('price') }}</p>
                                    @endif
                                
                              </div>
                            </div>
                            <div class="row">
                              <div class="form-group col-sm-4 @error('order_type') has-error @enderror">
                                <label for="order_type" class="control-label">{{ __('Order Type') }} <span class="text-danger">*</span></label>
                                {!! Form::select('order_type', $order_types, null, ['class' => 'form-control m-bot15', 'id' => 'order_type', 'required' => 'required']) !!}                                  
                                @if($errors->has('order_type'))
                                    <p class="text-danger">{{ $errors->first('order_type') }}</p>
                                @endif
                              </div>
                            </div>
                            <div class="row d-none" id="order_img" >
                              <div class="form-group col-sm-4 @error('express_image') has-error @enderror">
                                <label for="express_image" class="control-label">{{ __('Order Image') }} <span class="text-danger">*</span></label>
                                <input type="file" name="express_image" id="express_image"/>
                                @if($errors->has('express_image'))
                                    <p class="text-danger">{{ $errors->first('express_image') }}</p>
                                @endif
                              </div> 
                              
                            </div>
                            <div class="row">
                              <div class="form-group col-sm-4 @error('vehicle_type') has-error @enderror">
                                  <label for="vehicle_type" class="control-label">{{ __('Vehicle Type') }} <span class="text-danger">*</span></label>
                                  {!! Form::select('vehicle_type', $vehicle_types, null, ['class' => 'form-control m-bot15','required' => 'required']) !!}                                  
                                  @if($errors->has('vehicle_type'))
                                      <p class="text-danger">{{ $errors->first('vehicle_type') }}</p>
                                  @endif
                              </div>
                            </div>
                            <div class="row">
                               <!-- Date -->
                              <div class="form-group col-sm-4 @error('pickup_date') has-error @enderror">
                                <label for="pickup_date" class="control-label">{{ __('Pickup Date:') }}<span class="text-danger">*</span></label>

                                <div class="input-group date">
                                  <input type="text" class="form-control  datetimepicker-input" name="pickup_date" id="pickup_date" value="{{old('pickup_date')}}" placeholder="Pickup Date" required/>
                                  <div class="input-group-append" data-target="#pickup_date" data-toggle="datetimepicker">
                                      <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                  </div>
                                  @if($errors->has('pickup_date'))
                                      <p class="text-danger">{{ $errors->first('pickup_date') }}</p>
                                  @endif  
                                </div>


                                  
                              </div>
                            </div>
                            <div class="row">
                               <!-- time Picker -->
                              <div class="col-sm-4 bootstrap-timepicker">
                                <div class="form-group @error('pickup_time') has-error @enderror">
                                  <label for="pickup_time" class="control-label">{{ __('Pickup Time:') }}<span class="text-danger">*</span></label>

                                  <div class="input-group date" id="timepicker" data-target-input="nearest">
                                    <input type="text" class="form-control datetimepicker-input" name="pickup_time" id="pickup_time" placeholder="Pickup Time" data-target="#timepicker"/>
                                    <div class="input-group-append" data-target="#timepicker" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="far fa-clock"></i></div>
                                    </div>
                                    </div>
                                    @if($errors->has('pickup_time'))
                                    <p class="text-danger">{{ $errors->first('pickup_time') }}</p>
                                  @endif
                                  <!-- /.input group -->
                                </div>
                                <!-- /.form group -->
                              </div>
                            </div>
                              
                            <div class="row">
                              <div class="form-group col-sm-8  @error('remarks') has-error @enderror">
                                  <label for="remarks" class="control-label">{{ __('Remarks') }} <span class="text-danger">*</span></label>
                                  
                                      <textarea class="form-control" name="remarks"></textarea>
                                      @if($errors->has('remarks'))
                                          <p class="text-danger">{{ $errors->first('remarks') }}</p>
                                      @endif
                                  
                              </div> 
                            </div>
                          </div>
                        </div>
                     
                    
                        <div class="form-group row" style="text-align: center;">
                            <div class="col-sm-12">
                                <button type="submit" id="orderEditBtn" class="btn btn-primary">{{ __('Update Merchant') }}</button>
                                <a href="{{ route('merchant.order.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                        {!! Form::close() !!}
                  </div>
              </div>
          </div>
        </div>
      </div>
  </section>

<!-- page end-->
@endsection
@section('scripts')
<!-- Select2 -->
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>
<script>
  $('.select2').select2()
 $('.select2bs4').select2({
      theme: 'bootstrap4'
    })
   

</script>
@endsection