@extends('layouts.layout-admin')

@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Create User') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Create User') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('Create Users') }}</h3>                  
                        <span class="tools" style="float:right">
                            <a href="{{ route('user.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                        </span>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <form id="user_add_form" autocomplete="off" role="form" method="POST" action="{{ route('user.store') }}">
                            @csrf
                            <div class="form-group @error('user_name') has-error @enderror">
                                <label for="user_name" class="col-lg-4 col-sm-4 control-label"> {{ __('Name') }} <span class="text-danger">*</span></label>
                                <div class="col-lg-8">
                                    <input type="text" class="form-control" name="user_name" id="user_name" placeholder="Name" value="{{Request::old('user_name')}}" required maxlength="30">
                                    @if($errors->has('user_name'))
                                        <p class="text-danger">{{ $errors->first('user_name') }}</p>
                                    @endif
                                </div>
                            </div>
                        
                            <div class="form-group @error('email') has-error @enderror">
                                <label for="email" class="col-lg-4 col-sm-4 control-label">{{ __('Email') }}<span class="text-danger">*</span></label>
                                <div class="col-lg-8">
                                    <input type="email" class="form-control" name="email" id="email" placeholder="Email" value="{{Request::old('email')}}" required>
                                    @if($errors->has('email'))
                                        <p class="text-danger">{{ $errors->first('email') }}</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group @error('password') has-error @enderror">
                                <label for="password" class="col-lg-4 col-sm-4 control-label">{{ __('Password') }} <span class="text-danger">*</span></label>
                                <div class="col-lg-8">
                                    <input type="text" class="form-control" name="password" id="password"  placeholder="Password" value="{{ $password }}" required>
                                    @if($errors->has('password'))
                                        <p class="text-danger">{{ $errors->first('password') }}</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group @error('role') has-error @enderror">
                                <label class="col-lg-4 col-sm-4 control-label" for="role">Role <span class="text-danger">*</span></label>
                                <div class="col-lg-8">
                                    <select id="role" name="role" class="form-control" required>
                                        <option value="" disabled="disabled" selected> -- Select Role -- </option>
                                        @foreach($roles as $role)
                                            <option value="{{$role->name}}">{{$role->name}}</option>
                                        @endforeach
                                    </select>
                                    @if($errors->has('role'))
                                        <p class="text-danger">{{ $errors->first('role') }}</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group @error('supplier_user_id') has-error @enderror" id="supplierDiv" style="display:none;">
                                <label class="col-lg-4 col-sm-4 control-label" for="supplier_user_id">Supplier Name <span class="text-danger">*</span></label>
                                <div class="col-lg-8">
                                    <select id="supplier_user_id" name="supplier_user_id" class="form-control">
                                        <option value="" disabled="disabled" selected> -- Select Supplier -- </option>
                                        @foreach($supplierList as $supplier)
                                            <option value="{{$supplier->user_id}}">{{$supplier->supplier_company}} ({{$supplier->supplier_code}})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group" id="serviceDiv" style="display:none;"></div>
                            
                            <div class="form-group">
                                <div class="col-lg-offset-4 col-lg-8">
                                    <button type="button" onclick="validateForm();" id="userAddBtn" class="btn btn-primary">{{ __('Add User') }}</button>
                                    <a href="{{ route('user.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')
<script type="text/javascript">
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
});
$("#role").on('change', function() {
    if($("#role").val() == 'SUPPLIEREMP'){
        $("#supplierDiv").show();
    }else{
        $("#supplierDiv").hide();
    }
});
$("#supplier_user_id").on('change', function() {
    if($("#supplier_user_id").val()){
        $.ajax({
            url: "{{ route('user.getSupplierServiceList') }}",
            data: {"supplier_user_id": $("#supplier_user_id").val()},
            type: "post",
            dataType: "html",
            cache: false,
            success: function (html) {
                $("#serviceDiv").show();
                $( '#serviceDiv' ).html(html);
            }
        });
    }
});
function validateForm(){
    if($("#user_add_form #role").val() == 'SUPPLIEREMP'){
        var supplier = $("#user_add_form #supplier_user_id").val();
        if(supplier == "" || supplier == null){
            toastr.error('Please select the supplier.','Error');
            return false;
        }else{
            var service_name = [];
            $('.services:checked').each(function(){
                service_name.push($(this).val());
            });
            if(service_name == ""){
                toastr.error('Please select minimum one service.','Error');
                return false;
            }else{
                $('form#user_add_form').submit();
            }
        }
    }else{
        $('form#user_add_form').submit();
    }
}
</script>
@endsection