<form class="form-horizontal" id="market_add_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('market_name') has-error @enderror">
                <label for="market_name" class="control-label"> {{ __('Market Name') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="market_name" id="market_name" placeholder="Market Name">
                @if($errors->has('market_name'))
                    <p class="text-danger">{{ $errors->first('market_name') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('market_name_ar') has-error @enderror">
                <label for="market_name_ar" class="control-label"> {{ __('Market Name(AR)') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="market_name_ar" id="market_name_ar" placeholder="Market Name">
                @if($errors->has('market_name_ar'))
                    <p class="text-danger">{{ $errors->first('market_name_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('market_code') has-error @enderror">
                <label for="market_code" class="control-label"> {{ __('Market Code') }}</label>
                <input type="text" class="form-control" name="market_code" id="market_code" placeholder="Market Code">
                @if($errors->has('market_code'))
                    <p class="text-danger">{{ $errors->first('market_code') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('priority') has-error @enderror">
                <label for="priority" class="control-label"> {{ __('Priority') }}</label>
                <input type="text" class="form-control" name="priority" id="priority" placeholder="Priority">
                @if($errors->has('priority'))
                    <p class="text-danger">{{ $errors->first('priority') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('associated_countries') has-error @enderror">
                <label for="associated_countries" class="control-label"> {{ __('Associated Countries') }}</label>
                <input type="text" class="form-control" name="associated_countries" id="associated_countries" placeholder="Countries">
                @if($errors->has('associated_countries'))
                    <p class="text-danger">{{ $errors->first('associated_countries') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('status') has-error @enderror">
                <label for="status" class="control-label"> {{ __('Status') }} <span class="text-danger">*</span></label>
                {!! Form::select('status', $status, null, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('status'))
                    <p class="text-danger">{{ $errors->first('status') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
            <button type="button" id="addMarketBtn" class="btn btn-primary" onclick="return addMarket();">{{ __('Add Market') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
