<form class="form-horizontal" id="hotel_facility_edit_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('hotel_facility_name') has-error @enderror">
                <label for="hotel_facility_name" class="control-label"> {{ __('Hotel Facility Name') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="hotel_facility_name" id="hotel_facility_name" value="{{ $hotelFacilityInfo->hotel_facility_name }}" placeholder="Hotel Facility Name" required>
                @if($errors->has('hotel_facility_name'))
                    <p class="text-danger">{{ $errors->first('hotel_facility_name') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('hotel_facility_name_ar') has-error @enderror">
                <label for="hotel_facility_name_ar" class="control-label"> {{ __('Hotel Facility Name(AR)') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="hotel_facility_name_ar" id="hotel_facility_name_ar" value="{{ $hotelFacilityInfo->hotel_facility_name_ar }}" placeholder="Hotel Facility Name" required>
                @if($errors->has('hotel_facility_name_ar'))
                    <p class="text-danger">{{ $errors->first('hotel_facility_name_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('hotel_facility_code') has-error @enderror">
                <label for="hotel_facility_code" class="col-control-label"> {{ __('Hotel Facility Code') }} <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="hotel_facility_code" id="hotel_facility_code" value="{{ $hotelFacilityInfo->hotel_facility_code }}" placeholder="Hotel Facility Code" required>
                @if($errors->has('hotel_facility_code'))
                    <p class="text-danger">{{ $errors->first('hotel_facility_code') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('hotel_section_type') has-error @enderror">
                <label for="hotel_section_type" class="col-control-label"> {{ __('Section Type') }}</label>
                {!! Form::select('hotel_section_type', $sectionType, $hotelFacilityInfo->hotel_section_type, ['id' => 'hotel_section_type', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('hotel_section_type'))
                    <p class="text-danger">{{ $errors->first('hotel_section_type') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('hotel_facility_desc') has-error @enderror">
                <label for="hotel_facility_desc" class="control-label"> {{ __('Hotel Facility Desc') }}</label>
                <textarea class="form-control" name="hotel_facility_desc" id="hotel_facility_desc" rows="4">{{ $hotelFacilityInfo->hotel_facility_desc }}</textarea>
                @if($errors->has('hotel_facility_desc'))
                    <p class="text-danger">{{ $errors->first('hotel_facility_desc') }}</p>
                @endif
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group @error('hotel_facility_desc_ar') has-error @enderror">
                <label for="hotel_facility_desc_ar" class="control-label"> {{ __('Hotel Facility Desc(AR)') }}</label>
                <textarea class="form-control" name="hotel_facility_desc_ar" id="hotel_facility_desc_ar" rows="4">{{ $hotelFacilityInfo->hotel_facility_desc_ar }}</textarea>
                @if($errors->has('hotel_facility_desc_ar'))
                    <p class="text-danger">{{ $errors->first('hotel_facility_desc_ar') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group @error('status') has-error @enderror">
                <label for="status" class="control-label"> {{ __('Status') }} <span class="text-danger">*</span></label>
                {!! Form::select('status', $status, $hotelFacilityInfo->status, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                @if($errors->has('status'))
                    <p class="text-danger">{{ $errors->first('status') }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
        <input type="hidden" name="hotel_facility_id" id="hotel_facility_id" value="{{ $hotelFacilityInfo->id }}" />
            <button type="button" id="editHotelFacilityBtn" class="btn btn-primary" onclick="return editHotelFacility();">{{ __('Update Hotel Facility') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
