<form class="form-horizontal" id="contact_type_add_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group row @error('contact_type_name') has-error @enderror">
                <label for="contact_type_name" class="control-label col-sm-4"> {{ __('Type Name') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="contact_type_name" id="contact_type_name" placeholder="Type Name" required maxlength="30">
                    @if($errors->has('contact_type_name'))
                        <p class="text-danger">{{ $errors->first('contact_type_name') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('contact_type_name_ar') has-error @enderror">
                <label for="contact_type_name_ar" class="control-label col-sm-4"> {{ __('Type Name (AR)') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="contact_type_name_ar" id="contact_type_name_ar" placeholder="Type Name (AR)" required maxlength="30">
                    @if($errors->has('contact_type_name_ar'))
                        <p class="text-danger">{{ $errors->first('contact_type_name_ar') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('contact_type_code') has-error @enderror">
                <label for="contact_type_code" class="control-label col-sm-4"> {{ __('Type Code') }}</label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="contact_type_code" id="contact_type_code" placeholder="Type Code" maxlength="30">
                    @if($errors->has('contact_type_code'))
                        <p class="text-danger">{{ $errors->first('contact_type_code') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('status') has-error @enderror">
                <label for="status" class="control-label col-sm-4"> {{ __('Status') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    {!! Form::select('status', $status, null, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                    @if($errors->has('status'))
                        <p class="text-danger">{{ $errors->first('status') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
            <button type="button" id="contactTypeAddBtn" class="btn btn-primary" onclick="return addContactType();">{{ __('Add Contact Type') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
