@extends('layouts.layout-app')
@section('styles')
<style>
   #hide1{
   display:none;
   }
   #hide3{
   display:none;
   }
</style>
<!-- Select2 -->
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
   .control-label{
   text-align: right;
   }
   .hide{
   display: none;
   }
</style>
@endsection
@section('content')
<div class="register-box"  style="width:900px">
   <div class="card card-outline card-primary">
      <section class="content">
         <div class="container-fluid">
            <div class="row">
               <div class="col-12">
                  <div class="card">
                     <div class="card-header">
                        <!-- <h3 class="card-title">{{ __('Register a new membership') }}</h3>                   -->
                        <div class="card-header text-center">
                           <a href="{{ route('merchant.register') }}" class="h1"><b>{{ config('app.name', 'Laravel') }}</b></a>
                        </div>
                        <div class="card-body">
                           <p class="login-box-msg">{{ __('Register a new membership') }}</p>
                           @if ($message = Session::get('success'))
                              <div class="alert alert-success alert-block">
                                    <button type="button" class="close" data-dismiss="alert">×</button> 
                                    <strong>{{ $message }}</strong>
                              </div>
                           @endif
                           @if ($message = Session::get('failed') || $message = Session::get('error'))
                              <div class="alert alert-danger alert-block">
                                    <button type="button" class="close" data-dismiss="alert">×</button> 
                                    <strong>{{ $message }}</strong>
                              </div>
                           @endif     
                        </div>
                        <!-- /.card-header -->
                        <form action="{{ route('merchant.doRegister') }}" method="post" enctype="multipart/form-data">
                           @csrf
                           <div class="row">
                              <div class="col-lg-6">
                                 <div class="form-group row @error('first_name') has-error @enderror">
                                    <label for="first_name" class="control-label col-sm-4"> {{ __('First name') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="first_name" type="text" placeholder="First name" class="form-control @error('first_name') is-invalid @enderror" name="first_name" value="{{ old('first_name') }}" required maxlength="30" autofocus>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-user"></span>
                                                </div>
                                             </div>
                                             @error('first_name')
                                                <span class="invalid-feedback" role="alert">
                                                   <strong>{{ $message }}</strong>
                                                </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('last_name') has-error @enderror">
                                    <label for="last_name" class="control-label col-sm-4"> {{ __('Last name') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="last_name" type="text" placeholder="Last name" class="form-control @error('last_name') is-invalid @enderror" name="last_name" value="{{ old('last_name') }}" maxlength="30" required autofocus>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="far fa-user"></span>
                                                </div>
                                             </div>
                                             @error('last_name')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('email') has-error @enderror">
                                    <label for="email" class="control-label col-sm-4"> {{ __('Email') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="email" type="email" placeholder="Email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}"  required>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-envelope-open-text"></span>
                                                </div>
                                             </div>
                                             @error('email')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('phone') has-error @enderror">
                                    <label for="phone" class="control-label col-sm-4"> {{ __('Phone') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="phone" type="text" placeholder="Phone" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" maxlength="30" required autofocus>
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-phone"></span>
                                                </div>
                                             </div>
                                             @error('phone')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror                                          
                                       </div>
                                    </div>
                                 </div>
			                     </div>
                              <div class="col-lg-12">
                                 <div class="form-group row @error('address_1') has-error @enderror">
                                    <label for="address_1" class="control-label col-sm-2"> {{ __('Address') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group mb-3">
                                          <input id="address_1" type="text" placeholder="Address" class="form-control @error('address') is-invalid @enderror" name="address_1" value="{{ old('address_1') }}" required autofocus>
                                          <div class="input-group-append">
                                             <div class="input-group-text">
                                                   <span class="fas fa-address-card"></span>
                                             </div>
                                          </div>
                                          @error('address_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                    <div class="col-sm-2">
                                       <a href="#" class="btn btn-info" onclick="viewMapFirAddr();"><i class="fas fa-map-marker-alt"></i></a>
                                   </div>
                                 </div>
                              </div>
                              
                              <div class="col-lg-6">
                                 <div class="form-group row @error('postal_code_1') has-error @enderror">
                                    <label for="postal_code_1" class="control-label col-sm-4"> {{ __('Postal Code') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group mb-3">
                                          <input id="postal_code1" type="text" placeholder="Postal Code" class="form-control @error('postal_code_1') is-invalid @enderror" name="postal_code_1" value="{{ old('postal_code_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                                   <span class="fas fa-mail-bulk"></span>
                                          </div>
                                          </div>
                                          @error('postal_code_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('city_1') has-error @enderror">
                                    <label for="city_1" class="control-label col-sm-4"> {{ __('City') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group mb-3">
                                          <input id="locality1" type="text" placeholder="City" class="form-control @error('city_1') is-invalid @enderror" name="city_1" value="{{ old('city_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                                   <span class="fas fa-city"></span>
                                          </div>
                                          </div>
                                          @error('city_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('district_1') has-error @enderror">
                                    <label for="district_1" class="control-label col-sm-4"> {{ __('District') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group mb-3">
                                          <input id="administrative_area_level_21" type="text" placeholder="District" class="form-control @error('district_1') is-invalid @enderror" name="district_1" value="{{ old('district_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                                   <span class="fas fa-city"></span>
                                          </div>
                                          </div>
                                          @error('district_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('state_1') has-error @enderror">
                                    <label for="state_1" class="control-label col-sm-4"> {{ __('State') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group mb-3">
                                          <input id="administrative_area_level_11" type="text" placeholder="State" class="form-control @error('state_1') is-invalid @enderror" name="state_1" value="{{ old('state_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                                   <span class="fas fa-flag-usa"></span>
                                          </div>
                                          </div>
                                          @error('state_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('country_1') has-error @enderror">
                                    <label for="country_1" class="control-label col-sm-4"> {{ __('Country') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">                              
                                       <div class="input-group mb-3">
                                          <input id="country1" type="text" placeholder="Country" class="form-control @error('country_1') is-invalid @enderror" name="country_1" value="{{ old('country_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-globe"></span>
                                          </div>
                                          </div>
                                          @error('country_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('latitude_1') has-error @enderror">
                                    <label for="latitude_1" class="control-label col-sm-4"> {{ __('Latitude') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">                              
                                       <div class="input-group mb-3">
                                          <input id="latitude1" type="text" placeholder="Latitude" class="form-control @error('latitude_1') is-invalid @enderror" name="latitude_1" value="{{ old('latitude_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-globe"></span>
                                          </div>
                                          </div>
                                          @error('latitude_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                    
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('longitude_1') has-error @enderror">
                                    <label for="longitude_1" class="control-label col-sm-4"> {{ __('Longitude') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">                              
                                       <div class="input-group mb-3">
                                          <input id="longitude1" type="text" placeholder="Longitude" class="form-control @error('longitude_1') is-invalid @enderror" name="longitude_1" value="{{ old('longitude_1') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-globe"></span>
                                          </div>
                                          </div>
                                          @error('longitude_1')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <input type="hidden" class="form-control" name="map-view-flg-1" id="map-view-flg-1" />
                              <div class="col-lg-12">
                                 <div class="form-group row @error('address_2') has-error @enderror">
                                    <label for="address_2" class="control-label col-sm-2"> {{ __('Address 2') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">                                                            
                                       <div class="input-group mb-3">
                                          <input id="address_2" type="text" placeholder="Address 2" class="form-control @error('address_2') is-invalid @enderror" name="address_2" value="{{ old('address_2') }}" required autofocus>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-address-card"></span>
                                          </div>
                                          </div>
                                          @error('address_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                    <div class="col-sm-2">
                                       <a href="#" class="btn btn-info" onclick="viewMapSecAddr();"><i class="fas fa-map-marker-alt"></i></a>
                                   </div>
                                 </div>
                              </div>
                             
                              <div class="col-lg-6">
                                 <div class="form-group row @error('postal_code_2') has-error @enderror">
                                    <label for="postal_code_2" class="control-label col-sm-4"> {{ __('Postal Code') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group mb-3">
                                          <input id="postal_code2" type="text" placeholder="Postal Code" class="form-control @error('postal_code_2') is-invalid @enderror" name="postal_code_2" value="{{ old('postal_code_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-mail-bulk"></span>
                                          </div>
                                          </div>
                                          @error('postal_code_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('city_2') has-error @enderror">
                                    <label for="city_2" class="control-label col-sm-4"> {{ __('City') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">                                                            
                                       <div class="input-group mb-3">
                                          <input id="locality2" type="text" placeholder="City" class="form-control @error('city_2') is-invalid @enderror" name="city_2" value="{{ old('city_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-city"></span>
                                          </div>
                                          </div>
                                          @error('city_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('district_2') has-error @enderror">
                                    <label for="district_2" class="control-label col-sm-4"> {{ __('District') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">                                                            
                                       <div class="input-group mb-3">
                                          <input id="administrative_area_level_22" type="text" placeholder="District" class="form-control @error('district_2') is-invalid @enderror" name="district_2" value="{{ old('district_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-city"></span>
                                          </div>
                                          </div>
                                          @error('district_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('state_2') has-error @enderror">
                                    <label for="state_2" class="control-label col-sm-4"> {{ __('State') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                       <div class="input-group mb-3">
                                          <input id="administrative_area_level_12" type="text" placeholder="State" class="form-control @error('state_2') is-invalid @enderror" name="state_2" value="{{ old('state_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-flag-usa"></span>
                                          </div>
                                          </div>
                                          @error('state_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('country_2') has-error @enderror">
                                    <label for="country_2" class="control-label col-sm-4"> {{ __('Country') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                       <div class="input-group mb-3">
                                          <input id="country2" type="text" placeholder="Country" class="form-control @error('country_2') is-invalid @enderror" name="country_2" value="{{ old('country_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-globe"></span>
                                          </div>
                                          </div>
                                          @error('country_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('latitude_2') has-error @enderror">
                                    <label for="latitude_2" class="control-label col-sm-4"> {{ __('Latitude') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                       <div class="input-group mb-3">
                                          <input id="latitude2" type="text" placeholder="Latitude" class="form-control @error('latitude_2') is-invalid @enderror" name="latitude_2" value="{{ old('latitude_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-globe"></span>
                                          </div>
                                          </div>
                                          @error('latitude_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('longitude_2') has-error @enderror">
                                    <label for="longitude_2" class="control-label col-sm-4"> {{ __('Longitude') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                       <div class="input-group mb-3">
                                          <input id="longitude2" type="text" placeholder="Longitude" class="form-control @error('longitude_2') is-invalid @enderror" name="longitude_2" value="{{ old('longitude_2') }}" readonly>
                                          <div class="input-group-append">
                                          <div class="input-group-text">
                                             <span class="fas fa-globe"></span>
                                          </div>
                                          </div>
                                          @error('longitude_2')
                                             <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                             </span>
                                          @enderror
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <input type="hidden" class="form-control" name="map-view-flg-2" id="map-view-flg-2" />
                              <div class="col-lg-6">
                                 <div class="form-group row @error('ssm_number') has-error @enderror">
                                    <label for="ssm_number" class="control-label col-sm-4"> {{ __('SSM Number') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="ssm_number" type="text" placeholder="SSM Number" class="form-control @error('ssm_number') is-invalid @enderror" name="ssm_number" value="{{ old('ssm_number') }}" required autofocus>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-list-ol"></span>
                                                </div>
                                             </div>
                                             @error('ssm_number')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('company_name') has-error @enderror">
                                    <label for="company_name" class="control-label col-sm-4"> {{ __('Company Name') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="company_name" type="text" placeholder="Company Name" class="form-control @error('company_name') is-invalid @enderror" name="company_name" value="{{ old('company_name') }}" required autofocus>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-building"></span>
                                                </div>
                                             </div>
                                             @error('company_name')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('company_email') has-error @enderror">
                                    <label for="company_email" class="control-label col-sm-4"> {{ __('Company Email') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="company_email" type="email" placeholder="Company Email" class="form-control @error('company_email') is-invalid @enderror" name="company_email" value="{{ old('company_email') }}" required autofocus>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-envelope-open"></span>
                                                </div>
                                             </div>
                                             @error('company_email')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('company_phone') has-error @enderror">
                                    <label for="company_phone" class="control-label col-sm-4"> {{ __('Company Phone') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="company_phone" type="text" placeholder="Company Phone" class="form-control @error('company_phone') is-invalid @enderror" name="company_phone" value="{{ old('company_phone') }}" required autofocus>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fas fa-blender-phone"></span>
                                                </div>
                                             </div>
                                             @error('company_phone')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('logo') has-error @enderror">
                                    <label for="logo" class="control-label col-sm-4"> {{ __('Logo') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input type="file" name="logo" id="logo" class="form-control" accept="image/*" required>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fab fa-pied-piper-alt"></span>
                                                </div>
                                             </div>
                                             @error('logo')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('product_category') has-error @enderror">
                                    <label for="product_category" class="control-label col-sm-4"> {{ __('Select Product Category') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <select id="product_category" name="product_category[]" data-placeholder="Select Product Category" class="form-control select2" multiple="multiple" style="width: 230px;" required>
                                             <option value="0" selected> {{ __('all') }} </option>
                                             @foreach($product_category as $category)
                                             <option value="{{$category->id}}">{{$category->name}}</option>
                                             @endforeach
                                          </select>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span class="fab fa-product-hunt"></span>
                                                </div>
                                             </div>
                                             @error('product_category')
                                             <span class="invalid-feedback" role="alert">
                                             <strong>{{ $message }}</strong>
                                             </span>
                                             @enderror
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('product_images[]') has-error @enderror">
                                    <label for="product_images[]" class="control-label col-sm-4"> {{ __('Select Images') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group hdtuto control-group increment" >
                                          <div class="input-group">
                                             <input type="file" name="product_images[]" class="form-control" accept="image/*" required>
                                             <div class="input-group-btn"> 
                                                <button class="btn add-image btn-success" type="button"><i class="fldemo fa fa-plus"></i></button>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                    <div class="clone hide">
                                       <div class="hdtuto control-group input-group" style="margin-top:10px">
                                          <input type="file" name="product_images[]" class=" form-control" accept="image/*">
                                          <div class="input-group-btn"> 
                                             <button class="btn btn-danger remove-image" type="button"><i class="fldemo fa fa-trash"></i> </button>
                                          </div>
                                       </div>
                                    </div>
                                    @error('product_images')
                                    <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('password') has-error @enderror">
                                    <label for="password" class="control-label col-sm-4"> {{ __('Password') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="password" type="password" placeholder="Password" class="form-control @error('password') is-invalid @enderror" name="password" required>
                                          <div class="input-group-addon">
                                             <!-- <div class="input-group-append"> -->
                                             <div class="input-group-text">
                                                <span onclick="showPassword()">
                                                <i class="fas fa-eye" id="hide1"></i>
                                                <i class="fas fa-eye-slash" id="hide2"></i>
                                                </span>
                                                @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                             </div>
                                             <!-- </div> -->
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-lg-6">
                                 <div class="form-group row @error('password') has-error @enderror">
                                    <label for="password_confirm" class="control-label col-sm-4"> {{ __('Retype password') }} <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">
                                       <div class="input-group">
                                          <input id="password_confirm" type="password" placeholder="Retype password" class="form-control" name="password_confirm" required>
                                          
                                             <div class="input-group-append">
                                                <div class="input-group-text">
                                                   <span onclick="showPassword1()">
                                                   <i class="fas fa-eye" id="hide3"></i>
                                                   <i class="fas fa-eye-slash" id="hide4"></i>
                                                   </span>
                                                </div>
                                             </div>
                                          
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <!-- <div class="row"> -->
                              <div class="col-6" style="padding-left:100px;">
                                 <div class="icheck-primary">
                                    <input type="checkbox" id="agreeTerms" name="terms" value="agree">
                                    <label for="agreeTerms">
                                    I agree to the <a href="#">terms</a>
                                    </label>
                                 </div>
                              </div>
                              <!-- /.col -->
                              <div class="col-6">
                                 <div style="text-align:left;">
                                    <button type="submit" class="btn btn-primary ">{{ __('Register') }}</button>
                                 </div>
                              </div>
                           </div>
                           <!-- </div> -->
                        </form>
                        <div class="row">
                           <div class="col-12" style="text-align:center;">
                              <hr>
                              <a href="{{ route('merchant.login') }}">{{ __('Login') }}</a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
   </div>
</div>
@endsection
@section('scripts')
<!-- Select2 -->
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>
<script>
   $(function () {
      
       $('input').attr('autocomplete','off');
    //Initialize Select2 Elements
   $('.select2').select2()
    $('.select2bs4').select2({
         theme: 'bootstrap4'
       })
       $(".add-image").click(function(){ 
             var lsthmtl = $(".clone").html();
             $(".increment").after(lsthmtl);
         });
         $("body").on("click",".remove-image",function(){ 
             $(this).parents(".hdtuto").remove();
         });
     })
      
   //Initialize Select2 Elements
</script>
<script>
   $(function () {
     $('input').attr('autocomplete','off');
    
     $("form").submit(function(e){
         var viewMapFlgFirAddr = $('#map-view-flg-1').val();
         if(!viewMapFlgFirAddr)
         {            
           viewMapFirAddr();
           return false;
         }
         var viewMapFlgSecAddr = $('#map-view-flg-2').val();
         var addr2 = $("#address_2").val();
         if(addr2.length>0)
         {
           if(!viewMapFlgSecAddr)
           {               
               viewMapSecAddr();
               return false;
           }
       }
     });
 })
 
 </script>
 <script type="text/javascript" 
       src="https://maps.googleapis.com/maps/api/js?key={{ config('google.api_key') }}&callback=initAutocomplete&libraries=places&v=weekly"
       async
     ></script>
     <script>
      // This example displays an address form, using the autocomplete feature
// of the Google Places API to help users fill in the information.

var placeSearch, autocomplete, autocomplete2;
var componentForm = {
 street_number: 'long_name',
 route: 'long_name',
 locality: 'long_name',
 administrative_area_level_1: 'long_name',
 administrative_area_level_2: 'long_name',
 country: 'long_name',
 postal_code: 'long_name'
};

function initAutocomplete() {
 // Create the autocomplete object, restricting the search to geographical
 // location types.
 autocomplete = new google.maps.places.Autocomplete(
   /** @type {!HTMLInputElement} */
   (document.getElementById('address_1')), {
   //   types: ['geocode'],
     componentRestrictions: { country: ["my","in"] },
   });

 // When the user selects an address from the dropdown, populate the address
 // fields in the form.
 autocomplete.addListener('place_changed', function() {
   fillInAddress(autocomplete, "1");
 });

 autocomplete2 = new google.maps.places.Autocomplete(
   /** @type {!HTMLInputElement} */
   (document.getElementById('address_2')), {
   //   types: ['geocode'],
     componentRestrictions: { country: ["my","in"] },
   });
 autocomplete2.addListener('place_changed', function() {
   fillInAddress(autocomplete2, "2");
 });

}

function fillInAddress(autocomplete, unique) {
  
 // Get the place details from the autocomplete object.
 var place = autocomplete.getPlace();

 var lng =place.geometry.location.lng();
     var lat =place.geometry.location.lat();
       document.getElementById('longitude'+unique).value = lng;
      document.getElementById('latitude'+unique).value = lat;


 for (var component in componentForm) {
   if (!!document.getElementById(component + unique)) {
     document.getElementById(component + unique).value = '';
     document.getElementById(component + unique).disabled = false;
   }
 }

 // Get each component of the address from the place details
 // and fill the corresponding field on the form.
 for (var i = 0; i < place.address_components.length; i++) {
   var addressType = place.address_components[i].types[0];
   
   if (componentForm[addressType] && document.getElementById(addressType + unique)) {
     var val = place.address_components[i][componentForm[addressType]];
     
     document.getElementById(addressType + unique).value = val;
   }
 }
}
google.maps.event.addDomListener(window, "load", initAutocomplete);

function geolocate() {
 if (navigator.geolocation) {
   navigator.geolocation.getCurrentPosition(function(position) {
     var geolocation = {
       lat: position.coords.latitude,
       lng: position.coords.longitude
     };
     var circle = new google.maps.Circle({
       center: geolocation,
       radius: position.coords.accuracy
     });
     autocomplete.setBounds(circle.getBounds());
   });
 }
}
</script>
 
 
 <script type="text/javascript" src="{{ asset('plugins/jquery-locationpicker-plugin/master/dist/locationpicker.jquery.js') }}"></script>
 <script>
     function viewMapFirAddr(){
         delayInMilliseconds = 2000;
         setTimeout(function() {
             initAutocomplete();  
         }, delayInMilliseconds); 
         setTimeout(function() {
             fetchFirstMap();
         }, delayInMilliseconds);           
     }
     function viewMapSecAddr(){
         delayInMilliseconds = 2000;
         setTimeout(function() {
             initAutocomplete();  
         }, delayInMilliseconds); 
         setTimeout(function() {
             fetchSecondMap();
         }, delayInMilliseconds);           
     }
     function fetchFirstMap()
     {
         var title = "Map";
         var lat = ($("#latitude1").val())?$("#latitude1").val():'3.140853';
         var lng = ($("#longitude1").val())?$("#longitude1").val():'101.693207';
         $('#modal-xl-map').on('hidden.bs.modal', function(e){ 
               $(this).removeData();
           }) ;
         $("#map-view-flg-1").val(1);
         $(".modal-title").html(title);
         $("#modal-xl-map").modal('show');
         $('#getCode').locationpicker({
             location: {latitude: lat, longitude: lng},   
             radius: 0,
             inputBinding: {
                 latitudeInput: $('#latitude1'),
                 longitudeInput: $('#longitude1'),
                 // locationNameInput: $('#location'),
                 // radiusInput: $('#radius'),
                 // postalCodeInput: $('#postalCode'),
             },
             enableAutocomplete: true,
             onchanged: function(currentLocation, radius, isMarkerDropped) {
                 alert("Location changed. New location (" + currentLocation.latitude + ", " + currentLocation.longitude + ")");
                 }
             });
        
     }
     function fetchSecondMap()
     {
         var title = "Map";
         var lat = ($("#latitude2").val())?$("#latitude2").val():'3.140853';
         var lng = ($("#longitude2").val())?$("#longitude2").val():'101.693207';
         $('#modal-xl-map').on('hidden.bs.modal', function(e){ 
               $(this).removeData();
           }) ;
         $("#map-view-flg-2").val(1);
         $(".modal-title").html(title);
         $("#modal-xl-map").modal('show');
         $('#getCode').locationpicker({
             location: {latitude: lat, longitude: lng},   
             radius: 0,
             inputBinding: {
                 latitudeInput: $('#latitude2'),
                 longitudeInput: $('#longitude2'),
                 // locationNameInput: $('#location'),
                 // radiusInput: $('#radius'),
                 // postalCodeInput: $('#postalCode'),
             },
             enableAutocomplete: true,
             onchanged: function(currentLocation, radius, isMarkerDropped) {
                 alert("Location changed. New location (" + currentLocation.latitude + ", " + currentLocation.longitude + ")");
                 }
             });
        
     }
 </script>
 <script>
    
     $('#address_1').change(function(){
         
         $.ajaxSetup({
           headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
           }
         });
         
         var addr1 = $(this).val();    
         $.ajax({
             url: "{{ route('ajax-address') }}",
             data: { "addr": addr1 },
             type: "post",
             dataType: "json",
             success: function (address) 
             {
                 if(address)
                 {
                     $('input[name="city_1"]').val(address['city']);
                     $('input[name="state_1"]').val(address['state']);
                     $('input[name="district_1"]').val(address['district']);
                     $('input[name="postal_code_1"]').val(address['postal_code']);
                     $('input[name="country_1"]').val(address['country']);
                     $('input[name="latitude_1"]').val(address['latitude']);
                     $('input[name="longitude_1"]').val(address['longitude']);
                 }
                 else
                 {
                     alert('address not found..');              
                 }
             }
         });
     })

     $('#address_2').change(function(){
         
         $.ajaxSetup({
           headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
           }
         });
         
         var addr2 = $(this).val();      
         $.ajax({
             url: "{{ route('ajax-address') }}",
             data: { "addr": addr2 },
             type: "post",
             dataType: "json",
             success: function (address) 
             {
                 if(address)
                 {
                     $('input[name="city_2"]').val(address['city']);
                     $('input[name="state_2"]').val(address['state']);
                     $('input[name="district_2"]').val(address['district']);
                     $('input[name="postal_code_2"]').val(address['postal_code']);
                     $('input[name="country_2"]').val(address['country']);
                     $('input[name="latitude_2"]').val(address['latitude']);
                     $('input[name="longitude_2"]').val(address['longitude']);
                 }
                 else
                 {
                     alert('address not found..');              
                 }
             }
         });
     })

     
 </script>
@endsection