<?php

namespace App\Console\Commands;

use App\Models\OrderGrouping;
use App\Models\OrderGroupingAddress;
use App\Models\OrderGroupingPostalCode;
use Illuminate\Console\Command;
use DB;

class OrderGroupingPostalCodeCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order_grouping_postal_code:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Order Grouping Postal Codes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // return 0;

        DB::transaction(function()
        {
            $orderGroupings = OrderGroupingAddress::where('pickup_quantity',12)->where('status',0)->get();
            if(count($orderGroupings) > 0)
            {
                foreach($orderGroupings as $orderGrouping)
                {
                    $orderGroup = OrderGrouping::storeOrderGrouping($orderGrouping);
                }
            }

            $orderGroupingAddresses = OrderGroupingAddress::select('pickup_postal_code','pickup_city','pickup_latitude','pickup_longitude','pickup_location_id','pickup_date','pickup_time_id','drop_postal_code','drop_city','drop_latitude','drop_longitude','drop_location_id')->selectRaw("SUM(pickup_quantity) as pickup_quantity")->selectRaw("Sum(order_count) as order_count")->selectRaw("Count(order_grouping_address_id) as order_grouping_address_count")->where('status',0)->groupBy('pickup_postal_code','pickup_date','pickup_time_id')->get();
            \Log::info("ordergrouppostalcode".$orderGroupingAddresses);
            if(count($orderGroupingAddresses) > 0)
            {
                foreach($orderGroupingAddresses as $orderGroupingAddress)
                {                    
                    $orderGroupingPostalCode = OrderGroupingPostalCode::createOrderGroupingPostalCode($orderGroupingAddress);
                   
                }
            }
            else
            {
                dd("Insert Error :");
            }
            
        });
    }
}
