<?php

namespace App\Console\Commands;

use App\Models\OrderGrouping;
use App\Models\OrderGroupingLocation;
use App\Models\OrderGroupingPostalCode;
use Illuminate\Console\Command;
use DB;

class OrderGroupingLocationCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order_grouping_location:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Order Grouping Locations';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // return 0;

        DB::transaction(function()
        {
            $orderGroupings = OrderGroupingPostalCode::where('status' , 0);

            $orderGroupings = $orderGroupings->where("pickup_quantity" , "12")
                                ->orWhere('order_grouping_address_count' , "3")->get();
            \Log::info("ordergroupupdate".count($orderGroupings));
            if(count($orderGroupings) > 0)
            {
                foreach($orderGroupings as $orderGrouping)
                {
                    $orderGroup = OrderGrouping::storeOrderGrouping($orderGrouping);
                }
            }

            $orderGroupingPostalCodes = OrderGroupingPostalCode::select('pickup_city','pickup_latitude','pickup_longitude','pickup_location_id','pickup_date','pickup_time_id','drop_city','drop_latitude','drop_longitude','drop_location_id')->selectRaw("SUM(pickup_quantity) as pickup_quantity")->selectRaw("SUM(order_count) as order_count")->selectRaw("SUM(order_grouping_address_count) as order_grouping_address_count")->selectRaw("Count(order_grouping_postal_code_id) as order_grouping_postal_code_count")->where('status',0)->groupBy('pickup_location_id','pickup_date','pickup_time_id')->get();
            \Log::info("ordergrouppostalcode".$orderGroupingPostalCodes);
            if(count($orderGroupingPostalCodes) > 0)
            {
                foreach($orderGroupingPostalCodes as $orderGroupingPostalCode)
                {                    
                    $orderGroupingLocation = OrderGroupingLocation::createOrderGroupingLocation($orderGroupingPostalCode);
                   
                }
            }
            else
            {
                dd("Insert Error :");
            }
            
        });
    }
}
